/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The results extracted for a lending document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LendingDetection implements SdkPojo, Serializable,
        ToCopyableBuilder<LendingDetection.Builder, LendingDetection> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(LendingDetection::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> SELECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectionStatus").getter(getter(LendingDetection::selectionStatusAsString))
            .setter(setter(Builder::selectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionStatus").build()).build();

    private static final SdkField<Geometry> GEOMETRY_FIELD = SdkField.<Geometry> builder(MarshallingType.SDK_POJO)
            .memberName("Geometry").getter(getter(LendingDetection::geometry)).setter(setter(Builder::geometry))
            .constructor(Geometry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()).build();

    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Confidence").getter(getter(LendingDetection::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD,
            SELECTION_STATUS_FIELD, GEOMETRY_FIELD, CONFIDENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String text;

    private final String selectionStatus;

    private final Geometry geometry;

    private final Float confidence;

    private LendingDetection(BuilderImpl builder) {
        this.text = builder.text;
        this.selectionStatus = builder.selectionStatus;
        this.geometry = builder.geometry;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * The text extracted for a detected value in a lending document.
     * </p>
     * 
     * @return The text extracted for a detected value in a lending document.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The selection status of a selection element, such as an option button or check box.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectionStatus}
     * will return {@link SelectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #selectionStatusAsString}.
     * </p>
     * 
     * @return The selection status of a selection element, such as an option button or check box.
     * @see SelectionStatus
     */
    public final SelectionStatus selectionStatus() {
        return SelectionStatus.fromValue(selectionStatus);
    }

    /**
     * <p>
     * The selection status of a selection element, such as an option button or check box.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectionStatus}
     * will return {@link SelectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #selectionStatusAsString}.
     * </p>
     * 
     * @return The selection status of a selection element, such as an option button or check box.
     * @see SelectionStatus
     */
    public final String selectionStatusAsString() {
        return selectionStatus;
    }

    /**
     * Returns the value of the Geometry property for this object.
     * 
     * @return The value of the Geometry property for this object.
     */
    public final Geometry geometry() {
        return geometry;
    }

    /**
     * <p>
     * The confidence level for the text of a detected value in a lending document.
     * </p>
     * 
     * @return The confidence level for the text of a detected value in a lending document.
     */
    public final Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(selectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(geometry());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingDetection)) {
            return false;
        }
        LendingDetection other = (LendingDetection) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(selectionStatusAsString(), other.selectionStatusAsString())
                && Objects.equals(geometry(), other.geometry()) && Objects.equals(confidence(), other.confidence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LendingDetection").add("Text", text()).add("SelectionStatus", selectionStatusAsString())
                .add("Geometry", geometry()).add("Confidence", confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "SelectionStatus":
            return Optional.ofNullable(clazz.cast(selectionStatusAsString()));
        case "Geometry":
            return Optional.ofNullable(clazz.cast(geometry()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LendingDetection, T> g) {
        return obj -> g.apply((LendingDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LendingDetection> {
        /**
         * <p>
         * The text extracted for a detected value in a lending document.
         * </p>
         * 
         * @param text
         *        The text extracted for a detected value in a lending document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The selection status of a selection element, such as an option button or check box.
         * </p>
         * 
         * @param selectionStatus
         *        The selection status of a selection element, such as an option button or check box.
         * @see SelectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectionStatus
         */
        Builder selectionStatus(String selectionStatus);

        /**
         * <p>
         * The selection status of a selection element, such as an option button or check box.
         * </p>
         * 
         * @param selectionStatus
         *        The selection status of a selection element, such as an option button or check box.
         * @see SelectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectionStatus
         */
        Builder selectionStatus(SelectionStatus selectionStatus);

        /**
         * Sets the value of the Geometry property for this object.
         *
         * @param geometry
         *        The new value for the Geometry property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometry(Geometry geometry);

        /**
         * Sets the value of the Geometry property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Geometry.Builder} avoiding the need to
         * create one manually via {@link Geometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Geometry.Builder#build()} is called immediately and its result is
         * passed to {@link #geometry(Geometry)}.
         * 
         * @param geometry
         *        a consumer that will call methods on {@link Geometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometry(Geometry)
         */
        default Builder geometry(Consumer<Geometry.Builder> geometry) {
            return geometry(Geometry.builder().applyMutation(geometry).build());
        }

        /**
         * <p>
         * The confidence level for the text of a detected value in a lending document.
         * </p>
         * 
         * @param confidence
         *        The confidence level for the text of a detected value in a lending document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private String selectionStatus;

        private Geometry geometry;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(LendingDetection model) {
            text(model.text);
            selectionStatus(model.selectionStatus);
            geometry(model.geometry);
            confidence(model.confidence);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getSelectionStatus() {
            return selectionStatus;
        }

        public final void setSelectionStatus(String selectionStatus) {
            this.selectionStatus = selectionStatus;
        }

        @Override
        public final Builder selectionStatus(String selectionStatus) {
            this.selectionStatus = selectionStatus;
            return this;
        }

        @Override
        public final Builder selectionStatus(SelectionStatus selectionStatus) {
            this.selectionStatus(selectionStatus == null ? null : selectionStatus.toString());
            return this;
        }

        public final Geometry.Builder getGeometry() {
            return geometry != null ? geometry.toBuilder() : null;
        }

        public final void setGeometry(Geometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(Geometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final Float getConfidence() {
            return confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public LendingDetection build() {
            return new LendingDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
