/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.textract.DefaultTextractBaseClientBuilder;
import software.amazon.awssdk.services.textract.DefaultTextractClient;
import software.amazon.awssdk.services.textract.TextractClient;
import software.amazon.awssdk.services.textract.TextractClientBuilder;
import software.amazon.awssdk.services.textract.TextractServiceClientConfiguration;
import software.amazon.awssdk.services.textract.endpoints.TextractEndpointProvider;

@SdkInternalApi
final class DefaultTextractClientBuilder
extends DefaultTextractBaseClientBuilder<TextractClientBuilder, TextractClient>
implements TextractClientBuilder {
    DefaultTextractClientBuilder() {
    }

    @Override
    public DefaultTextractClientBuilder endpointProvider(TextractEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TextractClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultTextractClientBuilder.validateClientOptions(clientConfiguration);
        TextractServiceClientConfiguration serviceClientConfiguration = TextractServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultTextractClient(serviceClientConfiguration, clientConfiguration);
    }
}

