/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.textract.model.ExpenseDetection;
import software.amazon.awssdk.services.textract.model.ExpenseType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpenseField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpenseField> {
    private static final SdkField<ExpenseType> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Type").getter(ExpenseField.getter(ExpenseField::type)).setter(ExpenseField.setter(Builder::type)).constructor(ExpenseType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<ExpenseDetection> LABEL_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelDetection").getter(ExpenseField.getter(ExpenseField::labelDetection)).setter(ExpenseField.setter(Builder::labelDetection)).constructor(ExpenseDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelDetection").build()}).build();
    private static final SdkField<ExpenseDetection> VALUE_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueDetection").getter(ExpenseField.getter(ExpenseField::valueDetection)).setter(ExpenseField.setter(Builder::valueDetection)).constructor(ExpenseDetection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueDetection").build()}).build();
    private static final SdkField<Integer> PAGE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageNumber").getter(ExpenseField.getter(ExpenseField::pageNumber)).setter(ExpenseField.setter(Builder::pageNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LABEL_DETECTION_FIELD, VALUE_DETECTION_FIELD, PAGE_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final ExpenseType type;
    private final ExpenseDetection labelDetection;
    private final ExpenseDetection valueDetection;
    private final Integer pageNumber;

    private ExpenseField(BuilderImpl builder) {
        this.type = builder.type;
        this.labelDetection = builder.labelDetection;
        this.valueDetection = builder.valueDetection;
        this.pageNumber = builder.pageNumber;
    }

    public final ExpenseType type() {
        return this.type;
    }

    public final ExpenseDetection labelDetection() {
        return this.labelDetection;
    }

    public final ExpenseDetection valueDetection() {
        return this.valueDetection;
    }

    public final Integer pageNumber() {
        return this.pageNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelDetection());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueDetection());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpenseField)) {
            return false;
        }
        ExpenseField other = (ExpenseField)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.labelDetection(), other.labelDetection()) && Objects.equals(this.valueDetection(), other.valueDetection()) && Objects.equals(this.pageNumber(), other.pageNumber());
    }

    public final String toString() {
        return ToString.builder((String)"ExpenseField").add("Type", (Object)this.type()).add("LabelDetection", (Object)this.labelDetection()).add("ValueDetection", (Object)this.valueDetection()).add("PageNumber", (Object)this.pageNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "LabelDetection": {
                return Optional.ofNullable(clazz.cast(this.labelDetection()));
            }
            case "ValueDetection": {
                return Optional.ofNullable(clazz.cast(this.valueDetection()));
            }
            case "PageNumber": {
                return Optional.ofNullable(clazz.cast(this.pageNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExpenseField, T> g) {
        return obj -> g.apply((ExpenseField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ExpenseType type;
        private ExpenseDetection labelDetection;
        private ExpenseDetection valueDetection;
        private Integer pageNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpenseField model) {
            this.type(model.type);
            this.labelDetection(model.labelDetection);
            this.valueDetection(model.valueDetection);
            this.pageNumber(model.pageNumber);
        }

        public final ExpenseType.Builder getType() {
            return this.type != null ? this.type.toBuilder() : null;
        }

        public final void setType(ExpenseType.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(ExpenseType type) {
            this.type = type;
            return this;
        }

        public final ExpenseDetection.Builder getLabelDetection() {
            return this.labelDetection != null ? this.labelDetection.toBuilder() : null;
        }

        public final void setLabelDetection(ExpenseDetection.BuilderImpl labelDetection) {
            this.labelDetection = labelDetection != null ? labelDetection.build() : null;
        }

        @Override
        public final Builder labelDetection(ExpenseDetection labelDetection) {
            this.labelDetection = labelDetection;
            return this;
        }

        public final ExpenseDetection.Builder getValueDetection() {
            return this.valueDetection != null ? this.valueDetection.toBuilder() : null;
        }

        public final void setValueDetection(ExpenseDetection.BuilderImpl valueDetection) {
            this.valueDetection = valueDetection != null ? valueDetection.build() : null;
        }

        @Override
        public final Builder valueDetection(ExpenseDetection valueDetection) {
            this.valueDetection = valueDetection;
            return this;
        }

        public final Integer getPageNumber() {
            return this.pageNumber;
        }

        public final void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public final Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ExpenseField build() {
            return new ExpenseField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpenseField> {
        public Builder type(ExpenseType var1);

        default public Builder type(Consumer<ExpenseType.Builder> type) {
            return this.type((ExpenseType)((ExpenseType.Builder)ExpenseType.builder().applyMutation(type)).build());
        }

        public Builder labelDetection(ExpenseDetection var1);

        default public Builder labelDetection(Consumer<ExpenseDetection.Builder> labelDetection) {
            return this.labelDetection((ExpenseDetection)((ExpenseDetection.Builder)ExpenseDetection.builder().applyMutation(labelDetection)).build());
        }

        public Builder valueDetection(ExpenseDetection var1);

        default public Builder valueDetection(Consumer<ExpenseDetection.Builder> valueDetection) {
            return this.valueDetection((ExpenseDetection)((ExpenseDetection.Builder)ExpenseDetection.builder().applyMutation(valueDetection)).build());
        }

        public Builder pageNumber(Integer var1);
    }
}

