/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.DocumentMetadata;
import software.amazon.awssdk.services.textract.model.IdentityDocument;
import software.amazon.awssdk.services.textract.model.IdentityDocumentListCopier;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzeIdResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, AnalyzeIdResponse> {
    private static final SdkField<List<IdentityDocument>> IDENTITY_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentityDocuments").getter(AnalyzeIdResponse.getter(AnalyzeIdResponse::identityDocuments)).setter(AnalyzeIdResponse.setter(Builder::identityDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentMetadata").getter(AnalyzeIdResponse.getter(AnalyzeIdResponse::documentMetadata)).setter(AnalyzeIdResponse.setter(Builder::documentMetadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()}).build();
    private static final SdkField<String> ANALYZE_ID_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalyzeIDModelVersion").getter(AnalyzeIdResponse.getter(AnalyzeIdResponse::analyzeIDModelVersion)).setter(AnalyzeIdResponse.setter(Builder::analyzeIDModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzeIDModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_DOCUMENTS_FIELD, DOCUMENT_METADATA_FIELD, ANALYZE_ID_MODEL_VERSION_FIELD));
    private final List<IdentityDocument> identityDocuments;
    private final DocumentMetadata documentMetadata;
    private final String analyzeIDModelVersion;

    private AnalyzeIdResponse(BuilderImpl builder) {
        super(builder);
        this.identityDocuments = builder.identityDocuments;
        this.documentMetadata = builder.documentMetadata;
        this.analyzeIDModelVersion = builder.analyzeIDModelVersion;
    }

    public final boolean hasIdentityDocuments() {
        return this.identityDocuments != null && !(this.identityDocuments instanceof SdkAutoConstructList);
    }

    public final List<IdentityDocument> identityDocuments() {
        return this.identityDocuments;
    }

    public final DocumentMetadata documentMetadata() {
        return this.documentMetadata;
    }

    public final String analyzeIDModelVersion() {
        return this.analyzeIDModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityDocuments() ? this.identityDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzeIDModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeIdResponse)) {
            return false;
        }
        AnalyzeIdResponse other = (AnalyzeIdResponse)((Object)obj);
        return this.hasIdentityDocuments() == other.hasIdentityDocuments() && Objects.equals(this.identityDocuments(), other.identityDocuments()) && Objects.equals(this.documentMetadata(), other.documentMetadata()) && Objects.equals(this.analyzeIDModelVersion(), other.analyzeIDModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyzeIdResponse").add("IdentityDocuments", this.hasIdentityDocuments() ? this.identityDocuments() : null).add("DocumentMetadata", (Object)this.documentMetadata()).add("AnalyzeIDModelVersion", (Object)this.analyzeIDModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityDocuments": {
                return Optional.ofNullable(clazz.cast(this.identityDocuments()));
            }
            case "DocumentMetadata": {
                return Optional.ofNullable(clazz.cast(this.documentMetadata()));
            }
            case "AnalyzeIDModelVersion": {
                return Optional.ofNullable(clazz.cast(this.analyzeIDModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzeIdResponse, T> g) {
        return obj -> g.apply((AnalyzeIdResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private List<IdentityDocument> identityDocuments = DefaultSdkAutoConstructList.getInstance();
        private DocumentMetadata documentMetadata;
        private String analyzeIDModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzeIdResponse model) {
            super(model);
            this.identityDocuments(model.identityDocuments);
            this.documentMetadata(model.documentMetadata);
            this.analyzeIDModelVersion(model.analyzeIDModelVersion);
        }

        public final List<IdentityDocument.Builder> getIdentityDocuments() {
            List<IdentityDocument.Builder> result = IdentityDocumentListCopier.copyToBuilder(this.identityDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityDocuments(Collection<IdentityDocument.BuilderImpl> identityDocuments) {
            this.identityDocuments = IdentityDocumentListCopier.copyFromBuilder(identityDocuments);
        }

        @Override
        @Transient
        public final Builder identityDocuments(Collection<IdentityDocument> identityDocuments) {
            this.identityDocuments = IdentityDocumentListCopier.copy(identityDocuments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder identityDocuments(IdentityDocument ... identityDocuments) {
            this.identityDocuments(Arrays.asList(identityDocuments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder identityDocuments(Consumer<IdentityDocument.Builder> ... identityDocuments) {
            this.identityDocuments(Stream.of(identityDocuments).map(c -> (IdentityDocument)((IdentityDocument.Builder)IdentityDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return this.documentMetadata != null ? this.documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final String getAnalyzeIDModelVersion() {
            return this.analyzeIDModelVersion;
        }

        public final void setAnalyzeIDModelVersion(String analyzeIDModelVersion) {
            this.analyzeIDModelVersion = analyzeIDModelVersion;
        }

        @Override
        @Transient
        public final Builder analyzeIDModelVersion(String analyzeIDModelVersion) {
            this.analyzeIDModelVersion = analyzeIDModelVersion;
            return this;
        }

        @Override
        public AnalyzeIdResponse build() {
            return new AnalyzeIdResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AnalyzeIdResponse> {
        public Builder identityDocuments(Collection<IdentityDocument> var1);

        public Builder identityDocuments(IdentityDocument ... var1);

        public Builder identityDocuments(Consumer<IdentityDocument.Builder> ... var1);

        public Builder documentMetadata(DocumentMetadata var1);

        default public Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return this.documentMetadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(documentMetadata)).build());
        }

        public Builder analyzeIDModelVersion(String var1);
    }
}

