/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RelationshipType {
    VALUE("VALUE"),
    CHILD("CHILD"),
    COMPLEX_FEATURES("COMPLEX_FEATURES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RelationshipType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RelationshipType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RelationshipType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RelationshipType> knownValues() {
        return Stream.of(RelationshipType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

