/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.textract.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentLocation> {
    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Object").getter(DocumentLocation.getter(DocumentLocation::s3Object)).setter(DocumentLocation.setter(Builder::s3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Object").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OBJECT_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3Object s3Object;

    private DocumentLocation(BuilderImpl builder) {
        this.s3Object = builder.s3Object;
    }

    public S3Object s3Object() {
        return this.s3Object;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Object());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentLocation)) {
            return false;
        }
        DocumentLocation other = (DocumentLocation)obj;
        return Objects.equals(this.s3Object(), other.s3Object());
    }

    public String toString() {
        return ToString.builder((String)"DocumentLocation").add("S3Object", (Object)this.s3Object()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Object": {
                return Optional.ofNullable(clazz.cast(this.s3Object()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentLocation, T> g) {
        return obj -> g.apply((DocumentLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Object s3Object;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentLocation model) {
            this.s3Object(model.s3Object);
        }

        public final S3Object.Builder getS3Object() {
            return this.s3Object != null ? this.s3Object.toBuilder() : null;
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            this.s3Object = s3Object != null ? s3Object.build() : null;
        }

        public DocumentLocation build() {
            return new DocumentLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentLocation> {
        public Builder s3Object(S3Object var1);

        default public Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return this.s3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(s3Object)).build());
        }
    }
}

