/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDocumentAnalysisRequest extends TextractRequest implements
        ToCopyableBuilder<StartDocumentAnalysisRequest.Builder, StartDocumentAnalysisRequest> {
    private static final SdkField<DocumentLocation> DOCUMENT_LOCATION_FIELD = SdkField
            .<DocumentLocation> builder(MarshallingType.SDK_POJO).getter(getter(StartDocumentAnalysisRequest::documentLocation))
            .setter(setter(Builder::documentLocation)).constructor(DocumentLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentLocation").build()).build();

    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(StartDocumentAnalysisRequest::featureTypesAsStrings))
            .setter(setter(Builder::featureTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartDocumentAnalysisRequest::clientRequestToken)).setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final SdkField<String> JOB_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartDocumentAnalysisRequest::jobTag)).setter(setter(Builder::jobTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()).build();

    private static final SdkField<NotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField
            .<NotificationChannel> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartDocumentAnalysisRequest::notificationChannel)).setter(setter(Builder::notificationChannel))
            .constructor(NotificationChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_LOCATION_FIELD,
            FEATURE_TYPES_FIELD, CLIENT_REQUEST_TOKEN_FIELD, JOB_TAG_FIELD, NOTIFICATION_CHANNEL_FIELD));

    private final DocumentLocation documentLocation;

    private final List<String> featureTypes;

    private final String clientRequestToken;

    private final String jobTag;

    private final NotificationChannel notificationChannel;

    private StartDocumentAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.documentLocation = builder.documentLocation;
        this.featureTypes = builder.featureTypes;
        this.clientRequestToken = builder.clientRequestToken;
        this.jobTag = builder.jobTag;
        this.notificationChannel = builder.notificationChannel;
    }

    /**
     * <p>
     * The location of the document to be processed.
     * </p>
     * 
     * @return The location of the document to be processed.
     */
    public DocumentLocation documentLocation() {
        return documentLocation;
    }

    /**
     * <p>
     * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that
     * are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis,
     * add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are included in
     * the response (including text that isn't related to the value of <code>FeatureTypes</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFeatureTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
     *         that are detected in the input document. Add FORMS to return detected form data. To perform both types of
     *         analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document
     *         are included in the response (including text that isn't related to the value of <code>FeatureTypes</code>
     *         ).
     */
    public List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(featureTypes);
    }

    /**
     * Returns true if the FeatureTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFeatureTypes() {
        return featureTypes != null && !(featureTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables that
     * are detected in the input document. Add FORMS to return detected form data. To perform both types of analysis,
     * add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are included in
     * the response (including text that isn't related to the value of <code>FeatureTypes</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFeatureTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
     *         that are detected in the input document. Add FORMS to return detected form data. To perform both types of
     *         analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document
     *         are included in the response (including text that isn't related to the value of <code>FeatureTypes</code>
     *         ).
     */
    public List<String> featureTypesAsStrings() {
        return featureTypes;
    }

    /**
     * <p>
     * The idempotent token that you use to identify the start request. If you use the same token with multiple
     * <code>StartDocumentAnalysis</code> requests, the same <code>JobId</code> is returned. Use
     * <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For more
     * information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract
     * Asynchronous Operations</a>.
     * </p>
     * 
     * @return The idempotent token that you use to identify the start request. If you use the same token with multiple
     *         <code>StartDocumentAnalysis</code> requests, the same <code>JobId</code> is returned. Use
     *         <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once.
     *         For more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling
     *         Amazon Textract Asynchronous Operations</a>.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * An identifier that you specify that's included in the completion notification published to the Amazon SNS topic.
     * For example, you can use <code>JobTag</code> to identify the type of document that the completion notification
     * corresponds to (such as a tax form or a receipt).
     * </p>
     * 
     * @return An identifier that you specify that's included in the completion notification published to the Amazon SNS
     *         topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion
     *         notification corresponds to (such as a tax form or a receipt).
     */
    public String jobTag() {
        return jobTag;
    }

    /**
     * <p>
     * The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to.
     * </p>
     * 
     * @return The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation
     *         to.
     */
    public NotificationChannel notificationChannel() {
        return notificationChannel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(featureTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(jobTag());
        hashCode = 31 * hashCode + Objects.hashCode(notificationChannel());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDocumentAnalysisRequest)) {
            return false;
        }
        StartDocumentAnalysisRequest other = (StartDocumentAnalysisRequest) obj;
        return Objects.equals(documentLocation(), other.documentLocation())
                && Objects.equals(featureTypesAsStrings(), other.featureTypesAsStrings())
                && Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(jobTag(), other.jobTag())
                && Objects.equals(notificationChannel(), other.notificationChannel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartDocumentAnalysisRequest").add("DocumentLocation", documentLocation())
                .add("FeatureTypes", featureTypesAsStrings()).add("ClientRequestToken", clientRequestToken())
                .add("JobTag", jobTag()).add("NotificationChannel", notificationChannel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentLocation":
            return Optional.ofNullable(clazz.cast(documentLocation()));
        case "FeatureTypes":
            return Optional.ofNullable(clazz.cast(featureTypesAsStrings()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "JobTag":
            return Optional.ofNullable(clazz.cast(jobTag()));
        case "NotificationChannel":
            return Optional.ofNullable(clazz.cast(notificationChannel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDocumentAnalysisRequest, T> g) {
        return obj -> g.apply((StartDocumentAnalysisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartDocumentAnalysisRequest> {
        /**
         * <p>
         * The location of the document to be processed.
         * </p>
         * 
         * @param documentLocation
         *        The location of the document to be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentLocation(DocumentLocation documentLocation);

        /**
         * <p>
         * The location of the document to be processed.
         * </p>
         * This is a convenience that creates an instance of the {@link DocumentLocation.Builder} avoiding the need to
         * create one manually via {@link DocumentLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #documentLocation(DocumentLocation)}.
         * 
         * @param documentLocation
         *        a consumer that will call methods on {@link DocumentLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentLocation(DocumentLocation)
         */
        default Builder documentLocation(Consumer<DocumentLocation.Builder> documentLocation) {
            return documentLocation(DocumentLocation.builder().applyMutation(documentLocation).build());
        }

        /**
         * <p>
         * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
         * that are detected in the input document. Add FORMS to return detected form data. To perform both types of
         * analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
         * included in the response (including text that isn't related to the value of <code>FeatureTypes</code>).
         * </p>
         * 
         * @param featureTypes
         *        A list of the types of analysis to perform. Add TABLES to the list to return information about the
         *        tables that are detected in the input document. Add FORMS to return detected form data. To perform
         *        both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words
         *        detected in the document are included in the response (including text that isn't related to the value
         *        of <code>FeatureTypes</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(Collection<String> featureTypes);

        /**
         * <p>
         * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
         * that are detected in the input document. Add FORMS to return detected form data. To perform both types of
         * analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
         * included in the response (including text that isn't related to the value of <code>FeatureTypes</code>).
         * </p>
         * 
         * @param featureTypes
         *        A list of the types of analysis to perform. Add TABLES to the list to return information about the
         *        tables that are detected in the input document. Add FORMS to return detected form data. To perform
         *        both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words
         *        detected in the document are included in the response (including text that isn't related to the value
         *        of <code>FeatureTypes</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypesWithStrings(String... featureTypes);

        /**
         * <p>
         * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
         * that are detected in the input document. Add FORMS to return detected form data. To perform both types of
         * analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
         * included in the response (including text that isn't related to the value of <code>FeatureTypes</code>).
         * </p>
         * 
         * @param featureTypes
         *        A list of the types of analysis to perform. Add TABLES to the list to return information about the
         *        tables that are detected in the input document. Add FORMS to return detected form data. To perform
         *        both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words
         *        detected in the document are included in the response (including text that isn't related to the value
         *        of <code>FeatureTypes</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(Collection<FeatureType> featureTypes);

        /**
         * <p>
         * A list of the types of analysis to perform. Add TABLES to the list to return information about the tables
         * that are detected in the input document. Add FORMS to return detected form data. To perform both types of
         * analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words detected in the document are
         * included in the response (including text that isn't related to the value of <code>FeatureTypes</code>).
         * </p>
         * 
         * @param featureTypes
         *        A list of the types of analysis to perform. Add TABLES to the list to return information about the
         *        tables that are detected in the input document. Add FORMS to return detected form data. To perform
         *        both types of analysis, add TABLES and FORMS to <code>FeatureTypes</code>. All lines and words
         *        detected in the document are included in the response (including text that isn't related to the value
         *        of <code>FeatureTypes</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureTypes(FeatureType... featureTypes);

        /**
         * <p>
         * The idempotent token that you use to identify the start request. If you use the same token with multiple
         * <code>StartDocumentAnalysis</code> requests, the same <code>JobId</code> is returned. Use
         * <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than once. For
         * more information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon
         * Textract Asynchronous Operations</a>.
         * </p>
         * 
         * @param clientRequestToken
         *        The idempotent token that you use to identify the start request. If you use the same token with
         *        multiple <code>StartDocumentAnalysis</code> requests, the same <code>JobId</code> is returned. Use
         *        <code>ClientRequestToken</code> to prevent the same job from being accidentally started more than
         *        once. For more information, see <a
         *        href="https://docs.aws.amazon.com/textract/latest/dg/api-async.html">Calling Amazon Textract
         *        Asynchronous Operations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * An identifier that you specify that's included in the completion notification published to the Amazon SNS
         * topic. For example, you can use <code>JobTag</code> to identify the type of document that the completion
         * notification corresponds to (such as a tax form or a receipt).
         * </p>
         * 
         * @param jobTag
         *        An identifier that you specify that's included in the completion notification published to the Amazon
         *        SNS topic. For example, you can use <code>JobTag</code> to identify the type of document that the
         *        completion notification corresponds to (such as a tax form or a receipt).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTag(String jobTag);

        /**
         * <p>
         * The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to.
         * </p>
         * 
         * @param notificationChannel
         *        The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the
         *        operation to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationChannel(NotificationChannel notificationChannel);

        /**
         * <p>
         * The Amazon SNS topic ARN that you want Amazon Textract to publish the completion status of the operation to.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationChannel.Builder} avoiding the need
         * to create one manually via {@link NotificationChannel#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationChannel.Builder#build()} is called immediately and
         * its result is passed to {@link #notificationChannel(NotificationChannel)}.
         * 
         * @param notificationChannel
         *        a consumer that will call methods on {@link NotificationChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationChannel(NotificationChannel)
         */
        default Builder notificationChannel(Consumer<NotificationChannel.Builder> notificationChannel) {
            return notificationChannel(NotificationChannel.builder().applyMutation(notificationChannel).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TextractRequest.BuilderImpl implements Builder {
        private DocumentLocation documentLocation;

        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private String jobTag;

        private NotificationChannel notificationChannel;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDocumentAnalysisRequest model) {
            super(model);
            documentLocation(model.documentLocation);
            featureTypesWithStrings(model.featureTypes);
            clientRequestToken(model.clientRequestToken);
            jobTag(model.jobTag);
            notificationChannel(model.notificationChannel);
        }

        public final DocumentLocation.Builder getDocumentLocation() {
            return documentLocation != null ? documentLocation.toBuilder() : null;
        }

        @Override
        public final Builder documentLocation(DocumentLocation documentLocation) {
            this.documentLocation = documentLocation;
            return this;
        }

        public final void setDocumentLocation(DocumentLocation.BuilderImpl documentLocation) {
            this.documentLocation = documentLocation != null ? documentLocation.build() : null;
        }

        public final Collection<String> getFeatureTypes() {
            return featureTypes;
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String... featureTypes) {
            featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType... featureTypes) {
            featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getJobTag() {
            return jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        public final NotificationChannel.Builder getNotificationChannel() {
            return notificationChannel != null ? notificationChannel.toBuilder() : null;
        }

        @Override
        public final Builder notificationChannel(NotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final void setNotificationChannel(NotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDocumentAnalysisRequest build() {
            return new StartDocumentAnalysisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
