/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how blocks are related to each other. A <code>Block</code> object contains 0 or more
 * <code>Relation</code> objects in a list, <code>Relationships</code>. For more information, see <a>Block</a>.
 * </p>
 * <p>
 * The <code>Type</code> element provides the type of the relationship for all blocks in the <code>IDs</code> array.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Relationship implements SdkPojo, Serializable, ToCopyableBuilder<Relationship.Builder, Relationship> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Relationship::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<String>> IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Relationship::ids))
            .setter(setter(Builder::ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<String> ids;

    private Relationship(BuilderImpl builder) {
        this.type = builder.type;
        this.ids = builder.ids;
    }

    /**
     * <p>
     * The type of relationship that the blocks in the IDs array have with the current block. The relationship can be
     * <code>VALUE</code> or <code>CHILD</code>. A relationship of type VALUE is a list that contains the ID of the
     * VALUE block that's associated with the KEY of a key-value pair. A relationship of type CHILD is a list of IDs
     * that identify WORD blocks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of relationship that the blocks in the IDs array have with the current block. The relationship
     *         can be <code>VALUE</code> or <code>CHILD</code>. A relationship of type VALUE is a list that contains the
     *         ID of the VALUE block that's associated with the KEY of a key-value pair. A relationship of type CHILD is
     *         a list of IDs that identify WORD blocks.
     * @see RelationshipType
     */
    public RelationshipType type() {
        return RelationshipType.fromValue(type);
    }

    /**
     * <p>
     * The type of relationship that the blocks in the IDs array have with the current block. The relationship can be
     * <code>VALUE</code> or <code>CHILD</code>. A relationship of type VALUE is a list that contains the ID of the
     * VALUE block that's associated with the KEY of a key-value pair. A relationship of type CHILD is a list of IDs
     * that identify WORD blocks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of relationship that the blocks in the IDs array have with the current block. The relationship
     *         can be <code>VALUE</code> or <code>CHILD</code>. A relationship of type VALUE is a list that contains the
     *         ID of the VALUE block that's associated with the KEY of a key-value pair. A relationship of type CHILD is
     *         a list of IDs that identify WORD blocks.
     * @see RelationshipType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * Returns true if the Ids property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasIds() {
        return ids != null && !(ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of IDs for related blocks. You can get the type of the relationship from the <code>Type</code> element.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of IDs for related blocks. You can get the type of the relationship from the <code>Type</code>
     *         element.
     */
    public List<String> ids() {
        return ids;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ids());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(ids(), other.ids());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Relationship").add("Type", typeAsString()).add("Ids", ids()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Ids":
            return Optional.ofNullable(clazz.cast(ids()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Relationship, T> g) {
        return obj -> g.apply((Relationship) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Relationship> {
        /**
         * <p>
         * The type of relationship that the blocks in the IDs array have with the current block. The relationship can
         * be <code>VALUE</code> or <code>CHILD</code>. A relationship of type VALUE is a list that contains the ID of
         * the VALUE block that's associated with the KEY of a key-value pair. A relationship of type CHILD is a list of
         * IDs that identify WORD blocks.
         * </p>
         * 
         * @param type
         *        The type of relationship that the blocks in the IDs array have with the current block. The
         *        relationship can be <code>VALUE</code> or <code>CHILD</code>. A relationship of type VALUE is a list
         *        that contains the ID of the VALUE block that's associated with the KEY of a key-value pair. A
         *        relationship of type CHILD is a list of IDs that identify WORD blocks.
         * @see RelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of relationship that the blocks in the IDs array have with the current block. The relationship can
         * be <code>VALUE</code> or <code>CHILD</code>. A relationship of type VALUE is a list that contains the ID of
         * the VALUE block that's associated with the KEY of a key-value pair. A relationship of type CHILD is a list of
         * IDs that identify WORD blocks.
         * </p>
         * 
         * @param type
         *        The type of relationship that the blocks in the IDs array have with the current block. The
         *        relationship can be <code>VALUE</code> or <code>CHILD</code>. A relationship of type VALUE is a list
         *        that contains the ID of the VALUE block that's associated with the KEY of a key-value pair. A
         *        relationship of type CHILD is a list of IDs that identify WORD blocks.
         * @see RelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipType
         */
        Builder type(RelationshipType type);

        /**
         * <p>
         * An array of IDs for related blocks. You can get the type of the relationship from the <code>Type</code>
         * element.
         * </p>
         * 
         * @param ids
         *        An array of IDs for related blocks. You can get the type of the relationship from the
         *        <code>Type</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(Collection<String> ids);

        /**
         * <p>
         * An array of IDs for related blocks. You can get the type of the relationship from the <code>Type</code>
         * element.
         * </p>
         * 
         * @param ids
         *        An array of IDs for related blocks. You can get the type of the relationship from the
         *        <code>Type</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(String... ids);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Relationship model) {
            type(model.type);
            ids(model.ids);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RelationshipType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<String> getIds() {
            return ids;
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = IdListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String... ids) {
            ids(Arrays.asList(ids));
            return this;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = IdListCopier.copy(ids);
        }

        @Override
        public Relationship build() {
            return new Relationship(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
