/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDocumentAnalysisRequest extends TextractRequest implements
        ToCopyableBuilder<GetDocumentAnalysisRequest.Builder, GetDocumentAnalysisRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDocumentAnalysisRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetDocumentAnalysisRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDocumentAnalysisRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String jobId;

    private final Integer maxResults;

    private final String nextToken;

    private GetDocumentAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier for the text-detection job. The <code>JobId</code> is returned from
     * <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.
     * </p>
     * 
     * @return A unique identifier for the text-detection job. The <code>JobId</code> is returned from
     *         <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The maximum number of results to return per paginated call. The largest value that you can specify is 1,000. If
     * you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default value is 1,000.
     * </p>
     * 
     * @return The maximum number of results to return per paginated call. The largest value that you can specify is
     *         1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default
     *         value is 1,000.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns a
     * pagination token in the response. You can use this pagination token to retrieve the next set of blocks.
     * </p>
     * 
     * @return If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract
     *         returns a pagination token in the response. You can use this pagination token to retrieve the next set of
     *         blocks.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentAnalysisRequest)) {
            return false;
        }
        GetDocumentAnalysisRequest other = (GetDocumentAnalysisRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDocumentAnalysisRequest").add("JobId", jobId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentAnalysisRequest, T> g) {
        return obj -> g.apply((GetDocumentAnalysisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TextractRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDocumentAnalysisRequest> {
        /**
         * <p>
         * A unique identifier for the text-detection job. The <code>JobId</code> is returned from
         * <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.
         * </p>
         * 
         * @param jobId
         *        A unique identifier for the text-detection job. The <code>JobId</code> is returned from
         *        <code>StartDocumentAnalysis</code>. A <code>JobId</code> value is only valid for 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The maximum number of results to return per paginated call. The largest value that you can specify is 1,000.
         * If you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default value is
         * 1,000.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per paginated call. The largest value that you can specify is
         *        1,000. If you specify a value greater than 1,000, a maximum of 1,000 results is returned. The default
         *        value is 1,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract returns
         * a pagination token in the response. You can use this pagination token to retrieve the next set of blocks.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was incomplete (because there are more blocks to retrieve), Amazon Textract
         *        returns a pagination token in the response. You can use this pagination token to retrieve the next set
         *        of blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TextractRequest.BuilderImpl implements Builder {
        private String jobId;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentAnalysisRequest model) {
            super(model);
            jobId(model.jobId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDocumentAnalysisRequest build() {
            return new GetDocumentAnalysisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
