/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class RandomInputStream
extends InputStream {
    private static final Random RANDOM = new Random();
    private static final int MIN_CHAR_CODE = 32;
    private static final int MAX_CHAR_CODE = 125;
    protected long remainingBytes;
    protected final long lengthInBytes;
    private final boolean binaryData;

    public RandomInputStream(long lengthInBytes) {
        this(lengthInBytes, false);
    }

    public RandomInputStream(long lengthInBytes, boolean binaryData) {
        this.lengthInBytes = lengthInBytes;
        this.remainingBytes = lengthInBytes;
        this.binaryData = binaryData;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remainingBytes <= 0L) {
            return -1;
        }
        int bytesToRead = len;
        if ((long)bytesToRead > this.remainingBytes) {
            bytesToRead = (int)this.remainingBytes;
        }
        this.remainingBytes -= (long)bytesToRead;
        if (this.binaryData) {
            byte[] bytes = new byte[bytesToRead];
            RANDOM.nextBytes(bytes);
            System.arraycopy(bytes, 0, b, off, bytesToRead);
        } else {
            for (int i = 0; i < bytesToRead; ++i) {
                b[off + i] = (byte)(RANDOM.nextInt(93) + 32);
            }
        }
        return bytesToRead;
    }

    @Override
    public int read() throws IOException {
        if (this.remainingBytes <= 0L) {
            return -1;
        }
        --this.remainingBytes;
        if (this.binaryData) {
            byte[] bytes = new byte[1];
            RANDOM.nextBytes(bytes);
            return bytes[0];
        }
        return RANDOM.nextInt(93) + 32;
    }

    public long getBytesRead() {
        return this.lengthInBytes - this.remainingBytes;
    }
}

