/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.test.util;

import java.util.Collection;
import java.util.HashSet;

public class UnorderedCollectionComparator {
    public static <T> boolean equalUnorderedCollections(Collection<T> colA, Collection<T> colB) {
        return UnorderedCollectionComparator.equalUnorderedCollections(colA, colB, new CrossTypeComparator<T, T>(){

            @Override
            public boolean equals(T a, T b) {
                return a == null && b == null || a.equals(b);
            }
        });
    }

    public static <A, B> boolean equalUnorderedCollections(Collection<A> colA, Collection<B> colB, CrossTypeComparator<A, B> comparator) {
        if (colA == null || colB == null) {
            return !(colA != null && !colA.isEmpty() || colB != null && !colB.isEmpty());
        }
        HashSet<A> setA = new HashSet<A>();
        setA.addAll(colA);
        HashSet<B> setB = new HashSet<B>();
        setB.addAll(colB);
        if (setA.size() != setB.size()) {
            return false;
        }
        for (Object a : setA) {
            boolean foundA = false;
            for (Object b : setB) {
                if (!comparator.equals(a, b)) continue;
                foundA = true;
                break;
            }
            if (foundA) continue;
            return false;
        }
        return true;
    }

    public static interface CrossTypeComparator<A, B> {
        public boolean equals(A var1, B var2);
    }
}

