/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.support.SupportClient;
import software.amazon.awssdk.services.support.internal.UserAgentUtils;
import software.amazon.awssdk.services.support.model.CaseDetails;
import software.amazon.awssdk.services.support.model.DescribeCasesRequest;
import software.amazon.awssdk.services.support.model.DescribeCasesResponse;

public class DescribeCasesIterable
implements SdkIterable<DescribeCasesResponse> {
    private final SupportClient client;
    private final DescribeCasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCasesIterable(SupportClient client, DescribeCasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCasesResponseFetcher();
    }

    public Iterator<DescribeCasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CaseDetails> cases() {
        Function<DescribeCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.cases() != null) {
                return response.cases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCasesResponseFetcher
    implements SyncPageFetcher<DescribeCasesResponse> {
        private DescribeCasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCasesResponse nextPage(DescribeCasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCasesIterable.this.client.describeCases(DescribeCasesIterable.this.firstRequest);
            }
            return DescribeCasesIterable.this.client.describeCases((DescribeCasesRequest)((Object)DescribeCasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

