/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.support.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A communication associated with an AWS Support case. The communication consists of the case ID, the message body,
 * attachment information, the submitter of the communication, and the date and time of the communication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Communication implements SdkPojo, Serializable, ToCopyableBuilder<Communication.Builder, Communication> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Communication::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseId").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Communication::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<String> SUBMITTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Communication::submittedBy)).setter(setter(Builder::submittedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedBy").build()).build();

    private static final SdkField<String> TIME_CREATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Communication::timeCreated)).setter(setter(Builder::timeCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeCreated").build()).build();

    private static final SdkField<List<AttachmentDetails>> ATTACHMENT_SET_FIELD = SdkField
            .<List<AttachmentDetails>> builder(MarshallingType.LIST)
            .getter(getter(Communication::attachmentSet))
            .setter(setter(Builder::attachmentSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachmentDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachmentDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, BODY_FIELD,
            SUBMITTED_BY_FIELD, TIME_CREATED_FIELD, ATTACHMENT_SET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String caseId;

    private final String body;

    private final String submittedBy;

    private final String timeCreated;

    private final List<AttachmentDetails> attachmentSet;

    private Communication(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.body = builder.body;
        this.submittedBy = builder.submittedBy;
        this.timeCreated = builder.timeCreated;
        this.attachmentSet = builder.attachmentSet;
    }

    /**
     * <p>
     * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
     * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     * </p>
     * 
     * @return The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
     *         formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
     */
    public String caseId() {
        return caseId;
    }

    /**
     * <p>
     * The text of the communication between the customer and AWS Support.
     * </p>
     * 
     * @return The text of the communication between the customer and AWS Support.
     */
    public String body() {
        return body;
    }

    /**
     * <p>
     * The identity of the account that submitted, or responded to, the support case. Customer entries include the role
     * or IAM user as well as the email address. For example,
     * "AdminRole (Role) &lt;someone@example.com&gt;. Entries from the AWS Support team display "Amazon Web Services,"
     * and do not show an email address.
     * </p>
     * 
     * @return The identity of the account that submitted, or responded to, the support case. Customer entries include
     *         the role or IAM user as well as the email address. For example,
     *         "AdminRole (Role) &lt;someone@example.com&gt;. Entries from the AWS Support team display "Amazon Web
     *         Services," and do not show an email address.
     */
    public String submittedBy() {
        return submittedBy;
    }

    /**
     * <p>
     * The time the communication was created.
     * </p>
     * 
     * @return The time the communication was created.
     */
    public String timeCreated() {
        return timeCreated;
    }

    /**
     * Returns true if the AttachmentSet property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttachmentSet() {
        return attachmentSet != null && !(attachmentSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the attachments to the case communication.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachmentSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the attachments to the case communication.
     */
    public List<AttachmentDetails> attachmentSet() {
        return attachmentSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(submittedBy());
        hashCode = 31 * hashCode + Objects.hashCode(timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Communication)) {
            return false;
        }
        Communication other = (Communication) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(body(), other.body())
                && Objects.equals(submittedBy(), other.submittedBy()) && Objects.equals(timeCreated(), other.timeCreated())
                && Objects.equals(attachmentSet(), other.attachmentSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Communication").add("CaseId", caseId()).add("Body", body()).add("SubmittedBy", submittedBy())
                .add("TimeCreated", timeCreated()).add("AttachmentSet", attachmentSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "submittedBy":
            return Optional.ofNullable(clazz.cast(submittedBy()));
        case "timeCreated":
            return Optional.ofNullable(clazz.cast(timeCreated()));
        case "attachmentSet":
            return Optional.ofNullable(clazz.cast(attachmentSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Communication, T> g) {
        return obj -> g.apply((Communication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Communication> {
        /**
         * <p>
         * The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as
         * shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * </p>
         * 
         * @param caseId
         *        The AWS Support case ID requested or returned in the call. The case ID is an alphanumeric string
         *        formatted as shown in this example: case-<i>12345678910-2013-c4c1d2bf33c5cf47</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * The text of the communication between the customer and AWS Support.
         * </p>
         * 
         * @param body
         *        The text of the communication between the customer and AWS Support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * The identity of the account that submitted, or responded to, the support case. Customer entries include the
         * role or IAM user as well as the email address. For example,
         * "AdminRole (Role) &lt;someone@example.com&gt;. Entries from the AWS Support team display "Amazon Web
         * Services," and do not show an email address.
         * </p>
         * 
         * @param submittedBy
         *        The identity of the account that submitted, or responded to, the support case. Customer entries
         *        include the role or IAM user as well as the email address. For example,
         *        "AdminRole (Role) &lt;someone@example.com&gt;. Entries from the AWS Support team display "Amazon Web
         *        Services," and do not show an email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedBy(String submittedBy);

        /**
         * <p>
         * The time the communication was created.
         * </p>
         * 
         * @param timeCreated
         *        The time the communication was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeCreated(String timeCreated);

        /**
         * <p>
         * Information about the attachments to the case communication.
         * </p>
         * 
         * @param attachmentSet
         *        Information about the attachments to the case communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSet(Collection<AttachmentDetails> attachmentSet);

        /**
         * <p>
         * Information about the attachments to the case communication.
         * </p>
         * 
         * @param attachmentSet
         *        Information about the attachments to the case communication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentSet(AttachmentDetails... attachmentSet);

        /**
         * <p>
         * Information about the attachments to the case communication.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttachmentDetails>.Builder} avoiding the
         * need to create one manually via {@link List<AttachmentDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachmentDetails>.Builder#build()} is called immediately
         * and its result is passed to {@link #attachmentSet(List<AttachmentDetails>)}.
         * 
         * @param attachmentSet
         *        a consumer that will call methods on {@link List<AttachmentDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachmentSet(List<AttachmentDetails>)
         */
        Builder attachmentSet(Consumer<AttachmentDetails.Builder>... attachmentSet);
    }

    static final class BuilderImpl implements Builder {
        private String caseId;

        private String body;

        private String submittedBy;

        private String timeCreated;

        private List<AttachmentDetails> attachmentSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Communication model) {
            caseId(model.caseId);
            body(model.body);
            submittedBy(model.submittedBy);
            timeCreated(model.timeCreated);
            attachmentSet(model.attachmentSet);
        }

        public final String getCaseId() {
            return caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getBody() {
            return body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getSubmittedBy() {
            return submittedBy;
        }

        @Override
        public final Builder submittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
            return this;
        }

        public final void setSubmittedBy(String submittedBy) {
            this.submittedBy = submittedBy;
        }

        public final String getTimeCreated() {
            return timeCreated;
        }

        @Override
        public final Builder timeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(String timeCreated) {
            this.timeCreated = timeCreated;
        }

        public final Collection<AttachmentDetails.Builder> getAttachmentSet() {
            return attachmentSet != null ? attachmentSet.stream().map(AttachmentDetails::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder attachmentSet(Collection<AttachmentDetails> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copy(attachmentSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentSet(AttachmentDetails... attachmentSet) {
            attachmentSet(Arrays.asList(attachmentSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentSet(Consumer<AttachmentDetails.Builder>... attachmentSet) {
            attachmentSet(Stream.of(attachmentSet).map(c -> AttachmentDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttachmentSet(Collection<AttachmentDetails.BuilderImpl> attachmentSet) {
            this.attachmentSet = AttachmentSetCopier.copyFromBuilder(attachmentSet);
        }

        @Override
        public Communication build() {
            return new Communication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
