/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.SeverityLevel;
import software.amazon.awssdk.services.support.model.SeverityLevelsListCopier;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSeverityLevelsResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeSeverityLevelsResponse> {
    private static final SdkField<List<SeverityLevel>> SEVERITY_LEVELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSeverityLevelsResponse.getter(DescribeSeverityLevelsResponse::severityLevels)).setter(DescribeSeverityLevelsResponse.setter(Builder::severityLevels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityLevels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SeverityLevel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITY_LEVELS_FIELD));
    private final List<SeverityLevel> severityLevels;

    private DescribeSeverityLevelsResponse(BuilderImpl builder) {
        super(builder);
        this.severityLevels = builder.severityLevels;
    }

    public boolean hasSeverityLevels() {
        return this.severityLevels != null && !(this.severityLevels instanceof SdkAutoConstructList);
    }

    public List<SeverityLevel> severityLevels() {
        return this.severityLevels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.severityLevels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSeverityLevelsResponse)) {
            return false;
        }
        DescribeSeverityLevelsResponse other = (DescribeSeverityLevelsResponse)((Object)obj);
        return Objects.equals(this.severityLevels(), other.severityLevels());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSeverityLevelsResponse").add("SeverityLevels", this.severityLevels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "severityLevels": {
                return Optional.ofNullable(clazz.cast(this.severityLevels()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSeverityLevelsResponse, T> g) {
        return obj -> g.apply((DescribeSeverityLevelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private List<SeverityLevel> severityLevels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSeverityLevelsResponse model) {
            super(model);
            this.severityLevels(model.severityLevels);
        }

        public final Collection<SeverityLevel.Builder> getSeverityLevels() {
            return this.severityLevels != null ? (Collection)this.severityLevels.stream().map(SeverityLevel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder severityLevels(Collection<SeverityLevel> severityLevels) {
            this.severityLevels = SeverityLevelsListCopier.copy(severityLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(SeverityLevel ... severityLevels) {
            this.severityLevels(Arrays.asList(severityLevels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(Consumer<SeverityLevel.Builder> ... severityLevels) {
            this.severityLevels(Stream.of(severityLevels).map(c -> (SeverityLevel)((SeverityLevel.Builder)SeverityLevel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSeverityLevels(Collection<SeverityLevel.BuilderImpl> severityLevels) {
            this.severityLevels = SeverityLevelsListCopier.copyFromBuilder(severityLevels);
        }

        @Override
        public DescribeSeverityLevelsResponse build() {
            return new DescribeSeverityLevelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SupportResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSeverityLevelsResponse> {
        public Builder severityLevels(Collection<SeverityLevel> var1);

        public Builder severityLevels(SeverityLevel ... var1);

        public Builder severityLevels(Consumer<SeverityLevel.Builder> ... var1);
    }
}

