/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.Communication;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CommunicationMarshaller {
    private static final MarshallingInfo<String> CASEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("caseId").isBinary(false).build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("body").isBinary(false).build();
    private static final MarshallingInfo<String> SUBMITTEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("submittedBy").isBinary(false).build();
    private static final MarshallingInfo<String> TIMECREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeCreated").isBinary(false).build();
    private static final MarshallingInfo<List> ATTACHMENTSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachmentSet").isBinary(false).build();
    private static final CommunicationMarshaller INSTANCE = new CommunicationMarshaller();

    private CommunicationMarshaller() {
    }

    public static CommunicationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Communication communication, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)communication, (String)"communication");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)communication.caseId(), CASEID_BINDING);
            protocolMarshaller.marshall((Object)communication.body(), BODY_BINDING);
            protocolMarshaller.marshall((Object)communication.submittedBy(), SUBMITTEDBY_BINDING);
            protocolMarshaller.marshall((Object)communication.timeCreated(), TIMECREATED_BINDING);
            protocolMarshaller.marshall(communication.attachmentSet(), ATTACHMENTSET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

