/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.support.SupportClient;
import software.amazon.awssdk.services.support.model.Communication;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsRequest;
import software.amazon.awssdk.services.support.model.DescribeCommunicationsResponse;

public final class DescribeCommunicationsPaginator
implements SdkIterable<DescribeCommunicationsResponse> {
    private final SupportClient client;
    private final DescribeCommunicationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeCommunicationsPaginator(SupportClient client, DescribeCommunicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCommunicationsResponseFetcher();
    }

    public Iterator<DescribeCommunicationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Communication> communications() {
        Function<DescribeCommunicationsResponse, Iterator> getIterator = response -> response != null ? response.communications().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeCommunicationsResponseFetcher
    implements NextPageFetcher<DescribeCommunicationsResponse> {
        private DescribeCommunicationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCommunicationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeCommunicationsResponse nextPage(DescribeCommunicationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCommunicationsPaginator.this.client.describeCommunications(DescribeCommunicationsPaginator.this.firstRequest);
            }
            return DescribeCommunicationsPaginator.this.client.describeCommunications((DescribeCommunicationsRequest)((Object)DescribeCommunicationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

