/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.model.Communication;
import software.amazon.awssdk.services.support.model.CommunicationListCopier;
import software.amazon.awssdk.services.support.transform.RecentCaseCommunicationsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecentCaseCommunications
implements StructuredPojo,
ToCopyableBuilder<Builder, RecentCaseCommunications> {
    private final List<Communication> communications;
    private final String nextToken;

    private RecentCaseCommunications(BuilderImpl builder) {
        this.communications = builder.communications;
        this.nextToken = builder.nextToken;
    }

    public List<Communication> communications() {
        return this.communications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.communications());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecentCaseCommunications)) {
            return false;
        }
        RecentCaseCommunications other = (RecentCaseCommunications)obj;
        return Objects.equals(this.communications(), other.communications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.communications() != null) {
            sb.append("Communications: ").append(this.communications()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "communications": {
                return Optional.of(clazz.cast(this.communications()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecentCaseCommunicationsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Communication> communications;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RecentCaseCommunications model) {
            this.communications(model.communications);
            this.nextToken(model.nextToken);
        }

        public final Collection<Communication.Builder> getCommunications() {
            return this.communications != null ? (Collection)this.communications.stream().map(Communication::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder communications(Collection<Communication> communications) {
            this.communications = CommunicationListCopier.copy(communications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder communications(Communication ... communications) {
            this.communications(Arrays.asList(communications));
            return this;
        }

        public final void setCommunications(Collection<Communication.BuilderImpl> communications) {
            this.communications = CommunicationListCopier.copyFromBuilder(communications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public RecentCaseCommunications build() {
            return new RecentCaseCommunications(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecentCaseCommunications> {
        public Builder communications(Collection<Communication> var1);

        public Builder communications(Communication ... var1);

        public Builder nextToken(String var1);
    }
}

