/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.TrustedAdvisorResourcesSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TrustedAdvisorResourcesSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, TrustedAdvisorResourcesSummary> {
    private final Long resourcesProcessed;
    private final Long resourcesFlagged;
    private final Long resourcesIgnored;
    private final Long resourcesSuppressed;

    private TrustedAdvisorResourcesSummary(BuilderImpl builder) {
        this.resourcesProcessed = builder.resourcesProcessed;
        this.resourcesFlagged = builder.resourcesFlagged;
        this.resourcesIgnored = builder.resourcesIgnored;
        this.resourcesSuppressed = builder.resourcesSuppressed;
    }

    public Long resourcesProcessed() {
        return this.resourcesProcessed;
    }

    public Long resourcesFlagged() {
        return this.resourcesFlagged;
    }

    public Long resourcesIgnored() {
        return this.resourcesIgnored;
    }

    public Long resourcesSuppressed() {
        return this.resourcesSuppressed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourcesProcessed() == null ? 0 : this.resourcesProcessed().hashCode());
        hashCode = 31 * hashCode + (this.resourcesFlagged() == null ? 0 : this.resourcesFlagged().hashCode());
        hashCode = 31 * hashCode + (this.resourcesIgnored() == null ? 0 : this.resourcesIgnored().hashCode());
        hashCode = 31 * hashCode + (this.resourcesSuppressed() == null ? 0 : this.resourcesSuppressed().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedAdvisorResourcesSummary)) {
            return false;
        }
        TrustedAdvisorResourcesSummary other = (TrustedAdvisorResourcesSummary)obj;
        if (other.resourcesProcessed() == null ^ this.resourcesProcessed() == null) {
            return false;
        }
        if (other.resourcesProcessed() != null && !other.resourcesProcessed().equals(this.resourcesProcessed())) {
            return false;
        }
        if (other.resourcesFlagged() == null ^ this.resourcesFlagged() == null) {
            return false;
        }
        if (other.resourcesFlagged() != null && !other.resourcesFlagged().equals(this.resourcesFlagged())) {
            return false;
        }
        if (other.resourcesIgnored() == null ^ this.resourcesIgnored() == null) {
            return false;
        }
        if (other.resourcesIgnored() != null && !other.resourcesIgnored().equals(this.resourcesIgnored())) {
            return false;
        }
        if (other.resourcesSuppressed() == null ^ this.resourcesSuppressed() == null) {
            return false;
        }
        return other.resourcesSuppressed() == null || other.resourcesSuppressed().equals(this.resourcesSuppressed());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourcesProcessed() != null) {
            sb.append("ResourcesProcessed: ").append(this.resourcesProcessed()).append(",");
        }
        if (this.resourcesFlagged() != null) {
            sb.append("ResourcesFlagged: ").append(this.resourcesFlagged()).append(",");
        }
        if (this.resourcesIgnored() != null) {
            sb.append("ResourcesIgnored: ").append(this.resourcesIgnored()).append(",");
        }
        if (this.resourcesSuppressed() != null) {
            sb.append("ResourcesSuppressed: ").append(this.resourcesSuppressed()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourcesProcessed": {
                return Optional.of(clazz.cast(this.resourcesProcessed()));
            }
            case "resourcesFlagged": {
                return Optional.of(clazz.cast(this.resourcesFlagged()));
            }
            case "resourcesIgnored": {
                return Optional.of(clazz.cast(this.resourcesIgnored()));
            }
            case "resourcesSuppressed": {
                return Optional.of(clazz.cast(this.resourcesSuppressed()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedAdvisorResourcesSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long resourcesProcessed;
        private Long resourcesFlagged;
        private Long resourcesIgnored;
        private Long resourcesSuppressed;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustedAdvisorResourcesSummary model) {
            this.resourcesProcessed(model.resourcesProcessed);
            this.resourcesFlagged(model.resourcesFlagged);
            this.resourcesIgnored(model.resourcesIgnored);
            this.resourcesSuppressed(model.resourcesSuppressed);
        }

        public final Long getResourcesProcessed() {
            return this.resourcesProcessed;
        }

        @Override
        public final Builder resourcesProcessed(Long resourcesProcessed) {
            this.resourcesProcessed = resourcesProcessed;
            return this;
        }

        public final void setResourcesProcessed(Long resourcesProcessed) {
            this.resourcesProcessed = resourcesProcessed;
        }

        public final Long getResourcesFlagged() {
            return this.resourcesFlagged;
        }

        @Override
        public final Builder resourcesFlagged(Long resourcesFlagged) {
            this.resourcesFlagged = resourcesFlagged;
            return this;
        }

        public final void setResourcesFlagged(Long resourcesFlagged) {
            this.resourcesFlagged = resourcesFlagged;
        }

        public final Long getResourcesIgnored() {
            return this.resourcesIgnored;
        }

        @Override
        public final Builder resourcesIgnored(Long resourcesIgnored) {
            this.resourcesIgnored = resourcesIgnored;
            return this;
        }

        public final void setResourcesIgnored(Long resourcesIgnored) {
            this.resourcesIgnored = resourcesIgnored;
        }

        public final Long getResourcesSuppressed() {
            return this.resourcesSuppressed;
        }

        @Override
        public final Builder resourcesSuppressed(Long resourcesSuppressed) {
            this.resourcesSuppressed = resourcesSuppressed;
            return this;
        }

        public final void setResourcesSuppressed(Long resourcesSuppressed) {
            this.resourcesSuppressed = resourcesSuppressed;
        }

        public TrustedAdvisorResourcesSummary build() {
            return new TrustedAdvisorResourcesSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrustedAdvisorResourcesSummary> {
        public Builder resourcesProcessed(Long var1);

        public Builder resourcesFlagged(Long var1);

        public Builder resourcesIgnored(Long var1);

        public Builder resourcesSuppressed(Long var1);
    }
}

