/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.CreateCaseRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateCaseRequestModelMarshaller {
    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subject").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serviceCode").isBinary(false).build();
    private static final MarshallingInfo<String> SEVERITYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("severityCode").isBinary(false).build();
    private static final MarshallingInfo<String> CATEGORYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("categoryCode").isBinary(false).build();
    private static final MarshallingInfo<String> COMMUNICATIONBODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("communicationBody").isBinary(false).build();
    private static final MarshallingInfo<List> CCEMAILADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ccEmailAddresses").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("language").isBinary(false).build();
    private static final MarshallingInfo<String> ISSUETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("issueType").isBinary(false).build();
    private static final MarshallingInfo<String> ATTACHMENTSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attachmentSetId").isBinary(false).build();
    private static final CreateCaseRequestModelMarshaller INSTANCE = new CreateCaseRequestModelMarshaller();

    private CreateCaseRequestModelMarshaller() {
    }

    public static CreateCaseRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateCaseRequest createCaseRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createCaseRequest), (String)"createCaseRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createCaseRequest.subject(), SUBJECT_BINDING);
            protocolMarshaller.marshall((Object)createCaseRequest.serviceCode(), SERVICECODE_BINDING);
            protocolMarshaller.marshall((Object)createCaseRequest.severityCode(), SEVERITYCODE_BINDING);
            protocolMarshaller.marshall((Object)createCaseRequest.categoryCode(), CATEGORYCODE_BINDING);
            protocolMarshaller.marshall((Object)createCaseRequest.communicationBody(), COMMUNICATIONBODY_BINDING);
            protocolMarshaller.marshall(createCaseRequest.ccEmailAddresses(), CCEMAILADDRESSES_BINDING);
            protocolMarshaller.marshall((Object)createCaseRequest.language(), LANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)createCaseRequest.issueType(), ISSUETYPE_BINDING);
            protocolMarshaller.marshall((Object)createCaseRequest.attachmentSetId(), ATTACHMENTSETID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

