/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.support.model.SeverityLevel;
import software.amazon.awssdk.services.support.model.SeverityLevelsListCopier;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSeverityLevelsResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeSeverityLevelsResponse> {
    private final List<SeverityLevel> severityLevels;

    private DescribeSeverityLevelsResponse(BuilderImpl builder) {
        super(builder);
        this.severityLevels = builder.severityLevels;
    }

    public List<SeverityLevel> severityLevels() {
        return this.severityLevels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.severityLevels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSeverityLevelsResponse)) {
            return false;
        }
        DescribeSeverityLevelsResponse other = (DescribeSeverityLevelsResponse)((Object)obj);
        return Objects.equals(this.severityLevels(), other.severityLevels());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSeverityLevelsResponse").add("SeverityLevels", this.severityLevels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "severityLevels": {
                return Optional.ofNullable(clazz.cast(this.severityLevels()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private List<SeverityLevel> severityLevels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSeverityLevelsResponse model) {
            super(model);
            this.severityLevels(model.severityLevels);
        }

        public final Collection<SeverityLevel.Builder> getSeverityLevels() {
            return this.severityLevels != null ? (Collection)this.severityLevels.stream().map(SeverityLevel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder severityLevels(Collection<SeverityLevel> severityLevels) {
            this.severityLevels = SeverityLevelsListCopier.copy(severityLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(SeverityLevel ... severityLevels) {
            this.severityLevels(Arrays.asList(severityLevels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder severityLevels(Consumer<SeverityLevel.Builder> ... severityLevels) {
            this.severityLevels(Stream.of(severityLevels).map(c -> (SeverityLevel)((SeverityLevel.Builder)SeverityLevel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSeverityLevels(Collection<SeverityLevel.BuilderImpl> severityLevels) {
            this.severityLevels = SeverityLevelsListCopier.copyFromBuilder(severityLevels);
        }

        @Override
        public DescribeSeverityLevelsResponse build() {
            return new DescribeSeverityLevelsResponse(this);
        }
    }

    public static interface Builder
    extends SupportResponse.Builder,
    CopyableBuilder<Builder, DescribeSeverityLevelsResponse> {
        public Builder severityLevels(Collection<SeverityLevel> var1);

        public Builder severityLevels(SeverityLevel ... var1);

        public Builder severityLevels(Consumer<SeverityLevel.Builder> ... var1);
    }
}

