/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.support.model.CcEmailAddressListCopier;
import software.amazon.awssdk.services.support.model.SupportRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddCommunicationToCaseRequest
extends SupportRequest
implements ToCopyableBuilder<Builder, AddCommunicationToCaseRequest> {
    private final String caseId;
    private final String communicationBody;
    private final List<String> ccEmailAddresses;
    private final String attachmentSetId;

    private AddCommunicationToCaseRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.communicationBody = builder.communicationBody;
        this.ccEmailAddresses = builder.ccEmailAddresses;
        this.attachmentSetId = builder.attachmentSetId;
    }

    public String caseId() {
        return this.caseId;
    }

    public String communicationBody() {
        return this.communicationBody;
    }

    public List<String> ccEmailAddresses() {
        return this.ccEmailAddresses;
    }

    public String attachmentSetId() {
        return this.attachmentSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.caseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.communicationBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.ccEmailAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentSetId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCommunicationToCaseRequest)) {
            return false;
        }
        AddCommunicationToCaseRequest other = (AddCommunicationToCaseRequest)((Object)obj);
        return Objects.equals(this.caseId(), other.caseId()) && Objects.equals(this.communicationBody(), other.communicationBody()) && Objects.equals(this.ccEmailAddresses(), other.ccEmailAddresses()) && Objects.equals(this.attachmentSetId(), other.attachmentSetId());
    }

    public String toString() {
        return ToString.builder((String)"AddCommunicationToCaseRequest").add("CaseId", (Object)this.caseId()).add("CommunicationBody", (Object)this.communicationBody()).add("CcEmailAddresses", this.ccEmailAddresses()).add("AttachmentSetId", (Object)this.attachmentSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseId": {
                return Optional.ofNullable(clazz.cast(this.caseId()));
            }
            case "communicationBody": {
                return Optional.ofNullable(clazz.cast(this.communicationBody()));
            }
            case "ccEmailAddresses": {
                return Optional.ofNullable(clazz.cast(this.ccEmailAddresses()));
            }
            case "attachmentSetId": {
                return Optional.ofNullable(clazz.cast(this.attachmentSetId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SupportRequest.BuilderImpl
    implements Builder {
        private String caseId;
        private String communicationBody;
        private List<String> ccEmailAddresses = DefaultSdkAutoConstructList.getInstance();
        private String attachmentSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddCommunicationToCaseRequest model) {
            super(model);
            this.caseId(model.caseId);
            this.communicationBody(model.communicationBody);
            this.ccEmailAddresses(model.ccEmailAddresses);
            this.attachmentSetId(model.attachmentSetId);
        }

        public final String getCaseId() {
            return this.caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        public final String getCommunicationBody() {
            return this.communicationBody;
        }

        @Override
        public final Builder communicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
            return this;
        }

        public final void setCommunicationBody(String communicationBody) {
            this.communicationBody = communicationBody;
        }

        public final Collection<String> getCcEmailAddresses() {
            return this.ccEmailAddresses;
        }

        @Override
        public final Builder ccEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccEmailAddresses(String ... ccEmailAddresses) {
            this.ccEmailAddresses(Arrays.asList(ccEmailAddresses));
            return this;
        }

        public final void setCcEmailAddresses(Collection<String> ccEmailAddresses) {
            this.ccEmailAddresses = CcEmailAddressListCopier.copy(ccEmailAddresses);
        }

        public final String getAttachmentSetId() {
            return this.attachmentSetId;
        }

        @Override
        public final Builder attachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
            return this;
        }

        public final void setAttachmentSetId(String attachmentSetId) {
            this.attachmentSetId = attachmentSetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddCommunicationToCaseRequest build() {
            return new AddCommunicationToCaseRequest(this);
        }
    }

    public static interface Builder
    extends SupportRequest.Builder,
    CopyableBuilder<Builder, AddCommunicationToCaseRequest> {
        public Builder caseId(String var1);

        public Builder communicationBody(String var1);

        public Builder ccEmailAddresses(Collection<String> var1);

        public Builder ccEmailAddresses(String ... var1);

        public Builder attachmentSetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

