/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.support.model.CaseDetails;
import software.amazon.awssdk.services.support.model.CaseListCopier;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCasesResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeCasesResponse> {
    private final List<CaseDetails> cases;
    private final String nextToken;

    private DescribeCasesResponse(BuilderImpl builder) {
        super(builder);
        this.cases = builder.cases;
        this.nextToken = builder.nextToken;
    }

    public List<CaseDetails> cases() {
        return this.cases;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cases());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCasesResponse)) {
            return false;
        }
        DescribeCasesResponse other = (DescribeCasesResponse)((Object)obj);
        return Objects.equals(this.cases(), other.cases()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCasesResponse").add("Cases", this.cases()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cases": {
                return Optional.ofNullable(clazz.cast(this.cases()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private List<CaseDetails> cases = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCasesResponse model) {
            super(model);
            this.cases(model.cases);
            this.nextToken(model.nextToken);
        }

        public final Collection<CaseDetails.Builder> getCases() {
            return this.cases != null ? (Collection)this.cases.stream().map(CaseDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cases(Collection<CaseDetails> cases) {
            this.cases = CaseListCopier.copy(cases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(CaseDetails ... cases) {
            this.cases(Arrays.asList(cases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(Consumer<CaseDetails.Builder> ... cases) {
            this.cases(Stream.of(cases).map(c -> (CaseDetails)((CaseDetails.Builder)CaseDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCases(Collection<CaseDetails.BuilderImpl> cases) {
            this.cases = CaseListCopier.copyFromBuilder(cases);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeCasesResponse build() {
            return new DescribeCasesResponse(this);
        }
    }

    public static interface Builder
    extends SupportResponse.Builder,
    CopyableBuilder<Builder, DescribeCasesResponse> {
        public Builder cases(Collection<CaseDetails> var1);

        public Builder cases(CaseDetails ... var1);

        public Builder cases(Consumer<CaseDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

