/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.support.transform.AttachmentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Attachment
implements StructuredPojo,
ToCopyableBuilder<Builder, Attachment> {
    private final String fileName;
    private final SdkBytes data;

    private Attachment(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.data = builder.data;
    }

    public String fileName() {
        return this.fileName;
    }

    public SdkBytes data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachment)) {
            return false;
        }
        Attachment other = (Attachment)obj;
        return Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.data(), other.data());
    }

    public String toString() {
        return ToString.builder((String)"Attachment").add("FileName", (Object)this.fileName()).add("Data", (Object)this.data()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttachmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileName;
        private SdkBytes data;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachment model) {
            this.fileName(model.fileName);
            this.data(model.data);
        }

        public final String getFileName() {
            return this.fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public final ByteBuffer getData() {
            return this.data == null ? null : this.data.asByteBuffer();
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = StandardMemberCopier.copy((SdkBytes)data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data(data == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)data));
        }

        public Attachment build() {
            return new Attachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Attachment> {
        public Builder fileName(String var1);

        public Builder data(SdkBytes var1);
    }
}

