/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.transform;

import java.nio.ByteBuffer;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.support.model.Attachment;

@SdkInternalApi
public class AttachmentMarshaller {
    private static final MarshallingInfo<String> FILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileName").build();
    private static final MarshallingInfo<ByteBuffer> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("data").build();
    private static final AttachmentMarshaller instance = new AttachmentMarshaller();

    public static AttachmentMarshaller getInstance() {
        return instance;
    }

    public void marshall(Attachment attachment, ProtocolMarshaller protocolMarshaller) {
        if (attachment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)attachment.fileName(), FILENAME_BINDING);
            protocolMarshaller.marshall((Object)attachment.data(), DATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

