/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse;
import software.amazon.awssdk.services.sts.model.ExpiredTokenException;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.awssdk.services.sts.model.IdpCommunicationErrorException;
import software.amazon.awssdk.services.sts.model.IdpRejectedClaimException;
import software.amazon.awssdk.services.sts.model.InvalidAuthorizationMessageException;
import software.amazon.awssdk.services.sts.model.InvalidIdentityTokenException;
import software.amazon.awssdk.services.sts.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.sts.model.PackedPolicyTooLargeException;
import software.amazon.awssdk.services.sts.model.RegionDisabledException;
import software.amazon.awssdk.services.sts.model.StsException;
import software.amazon.awssdk.services.sts.transform.AssumeRoleRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithSamlRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetCallerIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetFederationTokenRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetSessionTokenRequestMarshaller;

@SdkInternalApi
final class DefaultStsClient
implements StsClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultStsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "sts";
    }

    @Override
    public AssumeRoleResponse assumeRole(AssumeRoleRequest assumeRoleRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AssumeRoleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRole").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)assumeRoleRequest).withMarshaller((Marshaller)new AssumeRoleRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AssumeRoleWithSamlResponse assumeRoleWithSAML(AssumeRoleWithSamlRequest assumeRoleWithSamlRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IdpRejectedClaimException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleWithSamlResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AssumeRoleWithSamlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRoleWithSAML").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)assumeRoleWithSamlRequest).withMarshaller((Marshaller)new AssumeRoleWithSamlRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AssumeRoleWithWebIdentityResponse assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, IdpRejectedClaimException, IdpCommunicationErrorException, InvalidIdentityTokenException, ExpiredTokenException, RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AssumeRoleWithWebIdentityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AssumeRoleWithWebIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRoleWithWebIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)assumeRoleWithWebIdentityRequest).withMarshaller((Marshaller)new AssumeRoleWithWebIdentityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DecodeAuthorizationMessageResponse decodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) throws InvalidAuthorizationMessageException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DecodeAuthorizationMessageResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DecodeAuthorizationMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DecodeAuthorizationMessage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)decodeAuthorizationMessageRequest).withMarshaller((Marshaller)new DecodeAuthorizationMessageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCallerIdentityResponse getCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) throws AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetCallerIdentityResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetCallerIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCallerIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCallerIdentityRequest).withMarshaller((Marshaller)new GetCallerIdentityRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetFederationTokenResponse getFederationToken(GetFederationTokenRequest getFederationTokenRequest) throws MalformedPolicyDocumentException, PackedPolicyTooLargeException, RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetFederationTokenResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetFederationTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFederationToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFederationTokenRequest).withMarshaller((Marshaller)new GetFederationTokenRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSessionTokenResponse getSessionToken(GetSessionTokenRequest getSessionTokenRequest) throws RegionDisabledException, AwsServiceException, SdkClientException, StsException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetSessionTokenResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (GetSessionTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSessionToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSessionTokenRequest).withMarshaller((Marshaller)new GetSessionTokenRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAuthorizationMessageException").exceptionBuilderSupplier(InvalidAuthorizationMessageException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExpiredTokenException").exceptionBuilderSupplier(ExpiredTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PackedPolicyTooLarge").exceptionBuilderSupplier(PackedPolicyTooLargeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RegionDisabledException").exceptionBuilderSupplier(RegionDisabledException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedPolicyDocument").exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IDPRejectedClaim").exceptionBuilderSupplier(IdpRejectedClaimException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidIdentityToken").exceptionBuilderSupplier(InvalidIdentityTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IDPCommunicationError").exceptionBuilderSupplier(IdpCommunicationErrorException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(StsException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }
}

