/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayClient;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse;
import software.amazon.awssdk.services.storagegateway.model.TapeArchive;

public class DescribeTapeArchivesIterable
implements SdkIterable<DescribeTapeArchivesResponse> {
    private final StorageGatewayClient client;
    private final DescribeTapeArchivesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTapeArchivesIterable(StorageGatewayClient client, DescribeTapeArchivesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTapeArchivesResponseFetcher();
    }

    public Iterator<DescribeTapeArchivesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TapeArchive> tapeArchives() {
        Function<DescribeTapeArchivesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tapeArchives() != null) {
                return response.tapeArchives().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTapeArchivesResponseFetcher
    implements SyncPageFetcher<DescribeTapeArchivesResponse> {
        private DescribeTapeArchivesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTapeArchivesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeTapeArchivesResponse nextPage(DescribeTapeArchivesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTapeArchivesIterable.this.client.describeTapeArchives(DescribeTapeArchivesIterable.this.firstRequest);
            }
            return DescribeTapeArchivesIterable.this.client.describeTapeArchives((DescribeTapeArchivesRequest)((Object)DescribeTapeArchivesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

