/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a bandwidth rate limit interval for a gateway. A bandwidth rate limit schedule consists of one or more
 * bandwidth rate limit intervals. A bandwidth rate limit interval defines a period of time on one or more days of the
 * week, during which bandwidth rate limits are specified for uploading, downloading, or both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BandwidthRateLimitInterval implements SdkPojo, Serializable,
        ToCopyableBuilder<BandwidthRateLimitInterval.Builder, BandwidthRateLimitInterval> {
    private static final SdkField<Integer> START_HOUR_OF_DAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartHourOfDay").getter(getter(BandwidthRateLimitInterval::startHourOfDay))
            .setter(setter(Builder::startHourOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartHourOfDay").build()).build();

    private static final SdkField<Integer> START_MINUTE_OF_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartMinuteOfHour").getter(getter(BandwidthRateLimitInterval::startMinuteOfHour))
            .setter(setter(Builder::startMinuteOfHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartMinuteOfHour").build()).build();

    private static final SdkField<Integer> END_HOUR_OF_DAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndHourOfDay").getter(getter(BandwidthRateLimitInterval::endHourOfDay))
            .setter(setter(Builder::endHourOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndHourOfDay").build()).build();

    private static final SdkField<Integer> END_MINUTE_OF_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndMinuteOfHour").getter(getter(BandwidthRateLimitInterval::endMinuteOfHour))
            .setter(setter(Builder::endMinuteOfHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndMinuteOfHour").build()).build();

    private static final SdkField<List<Integer>> DAYS_OF_WEEK_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("DaysOfWeek")
            .getter(getter(BandwidthRateLimitInterval::daysOfWeek))
            .setter(setter(Builder::daysOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DaysOfWeek").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AverageUploadRateLimitInBitsPerSec")
            .getter(getter(BandwidthRateLimitInterval::averageUploadRateLimitInBitsPerSec))
            .setter(setter(Builder::averageUploadRateLimitInBitsPerSec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageUploadRateLimitInBitsPerSec")
                    .build()).build();

    private static final SdkField<Long> AVERAGE_DOWNLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AverageDownloadRateLimitInBitsPerSec")
            .getter(getter(BandwidthRateLimitInterval::averageDownloadRateLimitInBitsPerSec))
            .setter(setter(Builder::averageDownloadRateLimitInBitsPerSec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AverageDownloadRateLimitInBitsPerSec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_HOUR_OF_DAY_FIELD,
            START_MINUTE_OF_HOUR_FIELD, END_HOUR_OF_DAY_FIELD, END_MINUTE_OF_HOUR_FIELD, DAYS_OF_WEEK_FIELD,
            AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD, AVERAGE_DOWNLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer startHourOfDay;

    private final Integer startMinuteOfHour;

    private final Integer endHourOfDay;

    private final Integer endMinuteOfHour;

    private final List<Integer> daysOfWeek;

    private final Long averageUploadRateLimitInBitsPerSec;

    private final Long averageDownloadRateLimitInBitsPerSec;

    private BandwidthRateLimitInterval(BuilderImpl builder) {
        this.startHourOfDay = builder.startHourOfDay;
        this.startMinuteOfHour = builder.startMinuteOfHour;
        this.endHourOfDay = builder.endHourOfDay;
        this.endMinuteOfHour = builder.endMinuteOfHour;
        this.daysOfWeek = builder.daysOfWeek;
        this.averageUploadRateLimitInBitsPerSec = builder.averageUploadRateLimitInBitsPerSec;
        this.averageDownloadRateLimitInBitsPerSec = builder.averageDownloadRateLimitInBitsPerSec;
    }

    /**
     * <p>
     * The hour of the day to start the bandwidth rate limit interval.
     * </p>
     * 
     * @return The hour of the day to start the bandwidth rate limit interval.
     */
    public final Integer startHourOfDay() {
        return startHourOfDay;
    }

    /**
     * <p>
     * The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of that
     * minute. To begin an interval exactly at the start of the hour, use the value <code>0</code>.
     * </p>
     * 
     * @return The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of
     *         that minute. To begin an interval exactly at the start of the hour, use the value <code>0</code>.
     */
    public final Integer startMinuteOfHour() {
        return startMinuteOfHour;
    }

    /**
     * <p>
     * The hour of the day to end the bandwidth rate limit interval.
     * </p>
     * 
     * @return The hour of the day to end the bandwidth rate limit interval.
     */
    public final Integer endHourOfDay() {
        return endHourOfDay;
    }

    /**
     * <p>
     * The minute of the hour to end the bandwidth rate limit interval.
     * </p>
     * <important>
     * <p>
     * The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an hour, use
     * the value <code>59</code>.
     * </p>
     * </important>
     * 
     * @return The minute of the hour to end the bandwidth rate limit interval. </p> <important>
     *         <p>
     *         The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an
     *         hour, use the value <code>59</code>.
     *         </p>
     */
    public final Integer endMinuteOfHour() {
        return endMinuteOfHour;
    }

    /**
     * Returns true if the DaysOfWeek property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDaysOfWeek() {
        return daysOfWeek != null && !(daysOfWeek instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from 0 to 6,
     * where 0 represents Sunday and 6 Saturday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDaysOfWeek()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from
     *         0 to 6, where 0 represents Sunday and 6 Saturday.
     */
    public final List<Integer> daysOfWeek() {
        return daysOfWeek;
    }

    /**
     * <p>
     * The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This field does
     * not appear in the response if the upload rate limit is not set.
     * </p>
     * 
     * @return The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This
     *         field does not appear in the response if the upload rate limit is not set.
     */
    public final Long averageUploadRateLimitInBitsPerSec() {
        return averageUploadRateLimitInBitsPerSec;
    }

    /**
     * <p>
     * The average download rate limit component of the bandwidth rate limit interval, in bits per second. This field
     * does not appear in the response if the download rate limit is not set.
     * </p>
     * 
     * @return The average download rate limit component of the bandwidth rate limit interval, in bits per second. This
     *         field does not appear in the response if the download rate limit is not set.
     */
    public final Long averageDownloadRateLimitInBitsPerSec() {
        return averageDownloadRateLimitInBitsPerSec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startHourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(startMinuteOfHour());
        hashCode = 31 * hashCode + Objects.hashCode(endHourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(endMinuteOfHour());
        hashCode = 31 * hashCode + Objects.hashCode(hasDaysOfWeek() ? daysOfWeek() : null);
        hashCode = 31 * hashCode + Objects.hashCode(averageUploadRateLimitInBitsPerSec());
        hashCode = 31 * hashCode + Objects.hashCode(averageDownloadRateLimitInBitsPerSec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BandwidthRateLimitInterval)) {
            return false;
        }
        BandwidthRateLimitInterval other = (BandwidthRateLimitInterval) obj;
        return Objects.equals(startHourOfDay(), other.startHourOfDay())
                && Objects.equals(startMinuteOfHour(), other.startMinuteOfHour())
                && Objects.equals(endHourOfDay(), other.endHourOfDay())
                && Objects.equals(endMinuteOfHour(), other.endMinuteOfHour()) && hasDaysOfWeek() == other.hasDaysOfWeek()
                && Objects.equals(daysOfWeek(), other.daysOfWeek())
                && Objects.equals(averageUploadRateLimitInBitsPerSec(), other.averageUploadRateLimitInBitsPerSec())
                && Objects.equals(averageDownloadRateLimitInBitsPerSec(), other.averageDownloadRateLimitInBitsPerSec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BandwidthRateLimitInterval").add("StartHourOfDay", startHourOfDay())
                .add("StartMinuteOfHour", startMinuteOfHour()).add("EndHourOfDay", endHourOfDay())
                .add("EndMinuteOfHour", endMinuteOfHour()).add("DaysOfWeek", hasDaysOfWeek() ? daysOfWeek() : null)
                .add("AverageUploadRateLimitInBitsPerSec", averageUploadRateLimitInBitsPerSec())
                .add("AverageDownloadRateLimitInBitsPerSec", averageDownloadRateLimitInBitsPerSec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartHourOfDay":
            return Optional.ofNullable(clazz.cast(startHourOfDay()));
        case "StartMinuteOfHour":
            return Optional.ofNullable(clazz.cast(startMinuteOfHour()));
        case "EndHourOfDay":
            return Optional.ofNullable(clazz.cast(endHourOfDay()));
        case "EndMinuteOfHour":
            return Optional.ofNullable(clazz.cast(endMinuteOfHour()));
        case "DaysOfWeek":
            return Optional.ofNullable(clazz.cast(daysOfWeek()));
        case "AverageUploadRateLimitInBitsPerSec":
            return Optional.ofNullable(clazz.cast(averageUploadRateLimitInBitsPerSec()));
        case "AverageDownloadRateLimitInBitsPerSec":
            return Optional.ofNullable(clazz.cast(averageDownloadRateLimitInBitsPerSec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BandwidthRateLimitInterval, T> g) {
        return obj -> g.apply((BandwidthRateLimitInterval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BandwidthRateLimitInterval> {
        /**
         * <p>
         * The hour of the day to start the bandwidth rate limit interval.
         * </p>
         * 
         * @param startHourOfDay
         *        The hour of the day to start the bandwidth rate limit interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startHourOfDay(Integer startHourOfDay);

        /**
         * <p>
         * The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of that
         * minute. To begin an interval exactly at the start of the hour, use the value <code>0</code>.
         * </p>
         * 
         * @param startMinuteOfHour
         *        The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of
         *        that minute. To begin an interval exactly at the start of the hour, use the value <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startMinuteOfHour(Integer startMinuteOfHour);

        /**
         * <p>
         * The hour of the day to end the bandwidth rate limit interval.
         * </p>
         * 
         * @param endHourOfDay
         *        The hour of the day to end the bandwidth rate limit interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endHourOfDay(Integer endHourOfDay);

        /**
         * <p>
         * The minute of the hour to end the bandwidth rate limit interval.
         * </p>
         * <important>
         * <p>
         * The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an hour,
         * use the value <code>59</code>.
         * </p>
         * </important>
         * 
         * @param endMinuteOfHour
         *        The minute of the hour to end the bandwidth rate limit interval. </p> <important>
         *        <p>
         *        The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an
         *        hour, use the value <code>59</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endMinuteOfHour(Integer endMinuteOfHour);

        /**
         * <p>
         * The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from 0 to
         * 6, where 0 represents Sunday and 6 Saturday.
         * </p>
         * 
         * @param daysOfWeek
         *        The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers
         *        from 0 to 6, where 0 represents Sunday and 6 Saturday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysOfWeek(Collection<Integer> daysOfWeek);

        /**
         * <p>
         * The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from 0 to
         * 6, where 0 represents Sunday and 6 Saturday.
         * </p>
         * 
         * @param daysOfWeek
         *        The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers
         *        from 0 to 6, where 0 represents Sunday and 6 Saturday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysOfWeek(Integer... daysOfWeek);

        /**
         * <p>
         * The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This field
         * does not appear in the response if the upload rate limit is not set.
         * </p>
         * 
         * @param averageUploadRateLimitInBitsPerSec
         *        The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This
         *        field does not appear in the response if the upload rate limit is not set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec);

        /**
         * <p>
         * The average download rate limit component of the bandwidth rate limit interval, in bits per second. This
         * field does not appear in the response if the download rate limit is not set.
         * </p>
         * 
         * @param averageDownloadRateLimitInBitsPerSec
         *        The average download rate limit component of the bandwidth rate limit interval, in bits per second.
         *        This field does not appear in the response if the download rate limit is not set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageDownloadRateLimitInBitsPerSec(Long averageDownloadRateLimitInBitsPerSec);
    }

    static final class BuilderImpl implements Builder {
        private Integer startHourOfDay;

        private Integer startMinuteOfHour;

        private Integer endHourOfDay;

        private Integer endMinuteOfHour;

        private List<Integer> daysOfWeek = DefaultSdkAutoConstructList.getInstance();

        private Long averageUploadRateLimitInBitsPerSec;

        private Long averageDownloadRateLimitInBitsPerSec;

        private BuilderImpl() {
        }

        private BuilderImpl(BandwidthRateLimitInterval model) {
            startHourOfDay(model.startHourOfDay);
            startMinuteOfHour(model.startMinuteOfHour);
            endHourOfDay(model.endHourOfDay);
            endMinuteOfHour(model.endMinuteOfHour);
            daysOfWeek(model.daysOfWeek);
            averageUploadRateLimitInBitsPerSec(model.averageUploadRateLimitInBitsPerSec);
            averageDownloadRateLimitInBitsPerSec(model.averageDownloadRateLimitInBitsPerSec);
        }

        public final Integer getStartHourOfDay() {
            return startHourOfDay;
        }

        @Override
        public final Builder startHourOfDay(Integer startHourOfDay) {
            this.startHourOfDay = startHourOfDay;
            return this;
        }

        public final void setStartHourOfDay(Integer startHourOfDay) {
            this.startHourOfDay = startHourOfDay;
        }

        public final Integer getStartMinuteOfHour() {
            return startMinuteOfHour;
        }

        @Override
        public final Builder startMinuteOfHour(Integer startMinuteOfHour) {
            this.startMinuteOfHour = startMinuteOfHour;
            return this;
        }

        public final void setStartMinuteOfHour(Integer startMinuteOfHour) {
            this.startMinuteOfHour = startMinuteOfHour;
        }

        public final Integer getEndHourOfDay() {
            return endHourOfDay;
        }

        @Override
        public final Builder endHourOfDay(Integer endHourOfDay) {
            this.endHourOfDay = endHourOfDay;
            return this;
        }

        public final void setEndHourOfDay(Integer endHourOfDay) {
            this.endHourOfDay = endHourOfDay;
        }

        public final Integer getEndMinuteOfHour() {
            return endMinuteOfHour;
        }

        @Override
        public final Builder endMinuteOfHour(Integer endMinuteOfHour) {
            this.endMinuteOfHour = endMinuteOfHour;
            return this;
        }

        public final void setEndMinuteOfHour(Integer endMinuteOfHour) {
            this.endMinuteOfHour = endMinuteOfHour;
        }

        public final Collection<Integer> getDaysOfWeek() {
            if (daysOfWeek instanceof SdkAutoConstructList) {
                return null;
            }
            return daysOfWeek;
        }

        @Override
        public final Builder daysOfWeek(Collection<Integer> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copy(daysOfWeek);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfWeek(Integer... daysOfWeek) {
            daysOfWeek(Arrays.asList(daysOfWeek));
            return this;
        }

        public final void setDaysOfWeek(Collection<Integer> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copy(daysOfWeek);
        }

        public final Long getAverageUploadRateLimitInBitsPerSec() {
            return averageUploadRateLimitInBitsPerSec;
        }

        @Override
        public final Builder averageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
            return this;
        }

        public final void setAverageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
        }

        public final Long getAverageDownloadRateLimitInBitsPerSec() {
            return averageDownloadRateLimitInBitsPerSec;
        }

        @Override
        public final Builder averageDownloadRateLimitInBitsPerSec(Long averageDownloadRateLimitInBitsPerSec) {
            this.averageDownloadRateLimitInBitsPerSec = averageDownloadRateLimitInBitsPerSec;
            return this;
        }

        public final void setAverageDownloadRateLimitInBitsPerSec(Long averageDownloadRateLimitInBitsPerSec) {
            this.averageDownloadRateLimitInBitsPerSec = averageDownloadRateLimitInBitsPerSec;
        }

        @Override
        public BandwidthRateLimitInterval build() {
            return new BandwidthRateLimitInterval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
