/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InvalidRequestExceptionReason {
    KMS_NOT_FOUND_EXCEPTION("KMS_NotFoundException"),
    KMS_INVALID_KEY_USAGE_EXCEPTION("KMS_InvalidKeyUsageException"),
    KMS_INVALID_STATE_EXCEPTION("KMS_InvalidStateException"),
    KMS_DISABLED_EXCEPTION("KMS_DisabledException"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InvalidRequestExceptionReason> VALUE_MAP;
    private final String value;

    private InvalidRequestExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InvalidRequestExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InvalidRequestExceptionReason> knownValues() {
        EnumSet<InvalidRequestExceptionReason> knownValues = EnumSet.allOf(InvalidRequestExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InvalidRequestExceptionReason.class, InvalidRequestExceptionReason::toString);
    }
}

