/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.ScopeTargetsCopier;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationAccessScopeResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, GetApplicationAccessScopeResponse> {
    private static final SdkField<List<String>> AUTHORIZED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedTargets").getter(GetApplicationAccessScopeResponse.getter(GetApplicationAccessScopeResponse::authorizedTargets)).setter(GetApplicationAccessScopeResponse.setter(Builder::authorizedTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(GetApplicationAccessScopeResponse.getter(GetApplicationAccessScopeResponse::scope)).setter(GetApplicationAccessScopeResponse.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_TARGETS_FIELD, SCOPE_FIELD));
    private final List<String> authorizedTargets;
    private final String scope;

    private GetApplicationAccessScopeResponse(BuilderImpl builder) {
        super(builder);
        this.authorizedTargets = builder.authorizedTargets;
        this.scope = builder.scope;
    }

    public final boolean hasAuthorizedTargets() {
        return this.authorizedTargets != null && !(this.authorizedTargets instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedTargets() {
        return this.authorizedTargets;
    }

    public final String scope() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedTargets() ? this.authorizedTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationAccessScopeResponse)) {
            return false;
        }
        GetApplicationAccessScopeResponse other = (GetApplicationAccessScopeResponse)((Object)obj);
        return this.hasAuthorizedTargets() == other.hasAuthorizedTargets() && Objects.equals(this.authorizedTargets(), other.authorizedTargets()) && Objects.equals(this.scope(), other.scope());
    }

    public final String toString() {
        return ToString.builder((String)"GetApplicationAccessScopeResponse").add("AuthorizedTargets", this.hasAuthorizedTargets() ? this.authorizedTargets() : null).add("Scope", (Object)this.scope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizedTargets": {
                return Optional.ofNullable(clazz.cast(this.authorizedTargets()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationAccessScopeResponse, T> g) {
        return obj -> g.apply((GetApplicationAccessScopeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private List<String> authorizedTargets = DefaultSdkAutoConstructList.getInstance();
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationAccessScopeResponse model) {
            super(model);
            this.authorizedTargets(model.authorizedTargets);
            this.scope(model.scope);
        }

        public final Collection<String> getAuthorizedTargets() {
            if (this.authorizedTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedTargets;
        }

        public final void setAuthorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
        }

        @Override
        public final Builder authorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTargets(String ... authorizedTargets) {
            this.authorizedTargets(Arrays.asList(authorizedTargets));
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public GetApplicationAccessScopeResponse build() {
            return new GetApplicationAccessScopeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationAccessScopeResponse> {
        public Builder authorizedTargets(Collection<String> var1);

        public Builder authorizedTargets(String ... var1);

        public Builder scope(String var1);
    }
}

