/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssoadmin.model.AuthorizationCodeGrant;
import software.amazon.awssdk.services.ssoadmin.model.JwtBearerGrant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Grant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Grant> {
    private static final SdkField<AuthorizationCodeGrant> AUTHORIZATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthorizationCode").getter(Grant.getter(Grant::authorizationCode)).setter(Grant.setter(Builder::authorizationCode)).constructor(AuthorizationCodeGrant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCode").build()}).build();
    private static final SdkField<JwtBearerGrant> JWT_BEARER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JwtBearer").getter(Grant.getter(Grant::jwtBearer)).setter(Grant.setter(Builder::jwtBearer)).constructor(JwtBearerGrant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwtBearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_CODE_FIELD, JWT_BEARER_FIELD));
    private static final long serialVersionUID = 1L;
    private final AuthorizationCodeGrant authorizationCode;
    private final JwtBearerGrant jwtBearer;
    private final Type type;

    private Grant(BuilderImpl builder) {
        this.authorizationCode = builder.authorizationCode;
        this.jwtBearer = builder.jwtBearer;
        this.type = builder.type;
    }

    public final AuthorizationCodeGrant authorizationCode() {
        return this.authorizationCode;
    }

    public final JwtBearerGrant jwtBearer() {
        return this.jwtBearer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwtBearer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Grant)) {
            return false;
        }
        Grant other = (Grant)obj;
        return Objects.equals(this.authorizationCode(), other.authorizationCode()) && Objects.equals(this.jwtBearer(), other.jwtBearer());
    }

    public final String toString() {
        return ToString.builder((String)"Grant").add("AuthorizationCode", (Object)this.authorizationCode()).add("JwtBearer", (Object)this.jwtBearer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizationCode": {
                return Optional.ofNullable(clazz.cast(this.authorizationCode()));
            }
            case "JwtBearer": {
                return Optional.ofNullable(clazz.cast(this.jwtBearer()));
            }
        }
        return Optional.empty();
    }

    public static Grant fromAuthorizationCode(AuthorizationCodeGrant authorizationCode) {
        return (Grant)Grant.builder().authorizationCode(authorizationCode).build();
    }

    public static Grant fromAuthorizationCode(Consumer<AuthorizationCodeGrant.Builder> authorizationCode) {
        AuthorizationCodeGrant.Builder builder = AuthorizationCodeGrant.builder();
        authorizationCode.accept(builder);
        return Grant.fromAuthorizationCode((AuthorizationCodeGrant)builder.build());
    }

    public static Grant fromJwtBearer(JwtBearerGrant jwtBearer) {
        return (Grant)Grant.builder().jwtBearer(jwtBearer).build();
    }

    public static Grant fromJwtBearer(Consumer<JwtBearerGrant.Builder> jwtBearer) {
        JwtBearerGrant.Builder builder = JwtBearerGrant.builder();
        jwtBearer.accept(builder);
        return Grant.fromJwtBearer((JwtBearerGrant)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Grant, T> g) {
        return obj -> g.apply((Grant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AUTHORIZATION_CODE,
        JWT_BEARER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AuthorizationCodeGrant authorizationCode;
        private JwtBearerGrant jwtBearer;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Grant model) {
            this.authorizationCode(model.authorizationCode);
            this.jwtBearer(model.jwtBearer);
        }

        public final AuthorizationCodeGrant.Builder getAuthorizationCode() {
            return this.authorizationCode != null ? this.authorizationCode.toBuilder() : null;
        }

        public final void setAuthorizationCode(AuthorizationCodeGrant.BuilderImpl authorizationCode) {
            AuthorizationCodeGrant oldValue = this.authorizationCode;
            this.authorizationCode = authorizationCode != null ? authorizationCode.build() : null;
            this.handleUnionValueChange(Type.AUTHORIZATION_CODE, oldValue, this.authorizationCode);
        }

        @Override
        public final Builder authorizationCode(AuthorizationCodeGrant authorizationCode) {
            AuthorizationCodeGrant oldValue = this.authorizationCode;
            this.authorizationCode = authorizationCode;
            this.handleUnionValueChange(Type.AUTHORIZATION_CODE, oldValue, this.authorizationCode);
            return this;
        }

        public final JwtBearerGrant.Builder getJwtBearer() {
            return this.jwtBearer != null ? this.jwtBearer.toBuilder() : null;
        }

        public final void setJwtBearer(JwtBearerGrant.BuilderImpl jwtBearer) {
            JwtBearerGrant oldValue = this.jwtBearer;
            this.jwtBearer = jwtBearer != null ? jwtBearer.build() : null;
            this.handleUnionValueChange(Type.JWT_BEARER, oldValue, this.jwtBearer);
        }

        @Override
        public final Builder jwtBearer(JwtBearerGrant jwtBearer) {
            JwtBearerGrant oldValue = this.jwtBearer;
            this.jwtBearer = jwtBearer;
            this.handleUnionValueChange(Type.JWT_BEARER, oldValue, this.jwtBearer);
            return this;
        }

        public Grant build() {
            return new Grant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Grant> {
        public Builder authorizationCode(AuthorizationCodeGrant var1);

        default public Builder authorizationCode(Consumer<AuthorizationCodeGrant.Builder> authorizationCode) {
            return this.authorizationCode((AuthorizationCodeGrant)((AuthorizationCodeGrant.Builder)AuthorizationCodeGrant.builder().applyMutation(authorizationCode)).build());
        }

        public Builder jwtBearer(JwtBearerGrant var1);

        default public Builder jwtBearer(Consumer<JwtBearerGrant.Builder> jwtBearer) {
            return this.jwtBearer((JwtBearerGrant)((JwtBearerGrant.Builder)JwtBearerGrant.builder().applyMutation(jwtBearer)).build());
        }
    }
}

