/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomerManagedPolicyReferencesInPermissionSetResponse extends SsoAdminResponse
        implements
        ToCopyableBuilder<ListCustomerManagedPolicyReferencesInPermissionSetResponse.Builder, ListCustomerManagedPolicyReferencesInPermissionSetResponse> {
    private static final SdkField<List<CustomerManagedPolicyReference>> CUSTOMER_MANAGED_POLICY_REFERENCES_FIELD = SdkField
            .<List<CustomerManagedPolicyReference>> builder(MarshallingType.LIST)
            .memberName("CustomerManagedPolicyReferences")
            .getter(getter(ListCustomerManagedPolicyReferencesInPermissionSetResponse::customerManagedPolicyReferences))
            .setter(setter(Builder::customerManagedPolicyReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerManagedPolicyReferences")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomerManagedPolicyReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomerManagedPolicyReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomerManagedPolicyReferencesInPermissionSetResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOMER_MANAGED_POLICY_REFERENCES_FIELD, NEXT_TOKEN_FIELD));

    private final List<CustomerManagedPolicyReference> customerManagedPolicyReferences;

    private final String nextToken;

    private ListCustomerManagedPolicyReferencesInPermissionSetResponse(BuilderImpl builder) {
        super(builder);
        this.customerManagedPolicyReferences = builder.customerManagedPolicyReferences;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomerManagedPolicyReferences
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCustomerManagedPolicyReferences() {
        return customerManagedPolicyReferences != null && !(customerManagedPolicyReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the names and paths of the customer managed policies that you have attached to your permission set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomerManagedPolicyReferences}
     * method.
     * </p>
     * 
     * @return Specifies the names and paths of the customer managed policies that you have attached to your permission
     *         set.
     */
    public final List<CustomerManagedPolicyReference> customerManagedPolicyReferences() {
        return customerManagedPolicyReferences;
    }

    /**
     * <p>
     * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make
     * subsequent calls.
     * </p>
     * 
     * @return The pagination token for the list API. Initially the value is null. Use the output of previous API calls
     *         to make subsequent calls.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCustomerManagedPolicyReferences() ? customerManagedPolicyReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomerManagedPolicyReferencesInPermissionSetResponse)) {
            return false;
        }
        ListCustomerManagedPolicyReferencesInPermissionSetResponse other = (ListCustomerManagedPolicyReferencesInPermissionSetResponse) obj;
        return hasCustomerManagedPolicyReferences() == other.hasCustomerManagedPolicyReferences()
                && Objects.equals(customerManagedPolicyReferences(), other.customerManagedPolicyReferences())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListCustomerManagedPolicyReferencesInPermissionSetResponse")
                .add("CustomerManagedPolicyReferences",
                        hasCustomerManagedPolicyReferences() ? customerManagedPolicyReferences() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerManagedPolicyReferences":
            return Optional.ofNullable(clazz.cast(customerManagedPolicyReferences()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomerManagedPolicyReferencesInPermissionSetResponse, T> g) {
        return obj -> g.apply((ListCustomerManagedPolicyReferencesInPermissionSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsoAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomerManagedPolicyReferencesInPermissionSetResponse> {
        /**
         * <p>
         * Specifies the names and paths of the customer managed policies that you have attached to your permission set.
         * </p>
         * 
         * @param customerManagedPolicyReferences
         *        Specifies the names and paths of the customer managed policies that you have attached to your
         *        permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedPolicyReferences(Collection<CustomerManagedPolicyReference> customerManagedPolicyReferences);

        /**
         * <p>
         * Specifies the names and paths of the customer managed policies that you have attached to your permission set.
         * </p>
         * 
         * @param customerManagedPolicyReferences
         *        Specifies the names and paths of the customer managed policies that you have attached to your
         *        permission set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedPolicyReferences(CustomerManagedPolicyReference... customerManagedPolicyReferences);

        /**
         * <p>
         * Specifies the names and paths of the customer managed policies that you have attached to your permission set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssoadmin.model.CustomerManagedPolicyReference.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ssoadmin.model.CustomerManagedPolicyReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssoadmin.model.CustomerManagedPolicyReference.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #customerManagedPolicyReferences(List<CustomerManagedPolicyReference>)}.
         * 
         * @param customerManagedPolicyReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssoadmin.model.CustomerManagedPolicyReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerManagedPolicyReferences(java.util.Collection<CustomerManagedPolicyReference>)
         */
        Builder customerManagedPolicyReferences(
                Consumer<CustomerManagedPolicyReference.Builder>... customerManagedPolicyReferences);

        /**
         * <p>
         * The pagination token for the list API. Initially the value is null. Use the output of previous API calls to
         * make subsequent calls.
         * </p>
         * 
         * @param nextToken
         *        The pagination token for the list API. Initially the value is null. Use the output of previous API
         *        calls to make subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private List<CustomerManagedPolicyReference> customerManagedPolicyReferences = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomerManagedPolicyReferencesInPermissionSetResponse model) {
            super(model);
            customerManagedPolicyReferences(model.customerManagedPolicyReferences);
            nextToken(model.nextToken);
        }

        public final List<CustomerManagedPolicyReference.Builder> getCustomerManagedPolicyReferences() {
            List<CustomerManagedPolicyReference.Builder> result = CustomerManagedPolicyReferenceListCopier
                    .copyToBuilder(this.customerManagedPolicyReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomerManagedPolicyReferences(
                Collection<CustomerManagedPolicyReference.BuilderImpl> customerManagedPolicyReferences) {
            this.customerManagedPolicyReferences = CustomerManagedPolicyReferenceListCopier
                    .copyFromBuilder(customerManagedPolicyReferences);
        }

        @Override
        public final Builder customerManagedPolicyReferences(
                Collection<CustomerManagedPolicyReference> customerManagedPolicyReferences) {
            this.customerManagedPolicyReferences = CustomerManagedPolicyReferenceListCopier.copy(customerManagedPolicyReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerManagedPolicyReferences(CustomerManagedPolicyReference... customerManagedPolicyReferences) {
            customerManagedPolicyReferences(Arrays.asList(customerManagedPolicyReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerManagedPolicyReferences(
                Consumer<CustomerManagedPolicyReference.Builder>... customerManagedPolicyReferences) {
            customerManagedPolicyReferences(Stream.of(customerManagedPolicyReferences)
                    .map(c -> CustomerManagedPolicyReference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomerManagedPolicyReferencesInPermissionSetResponse build() {
            return new ListCustomerManagedPolicyReferencesInPermissionSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
