/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.PrincipalType;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.services.ssoadmin.model.TargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAccountAssignmentRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, DeleteAccountAssignmentRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceArn").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::instanceArn)).setter(DeleteAccountAssignmentRequest.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetId").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::targetId)).setter(DeleteAccountAssignmentRequest.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::targetTypeAsString)).setter(DeleteAccountAssignmentRequest.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionSetArn").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::permissionSetArn)).setter(DeleteAccountAssignmentRequest.setter(Builder::permissionSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()}).build();
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalType").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::principalTypeAsString)).setter(DeleteAccountAssignmentRequest.setter(Builder::principalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalId").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::principalId)).setter(DeleteAccountAssignmentRequest.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, TARGET_ID_FIELD, TARGET_TYPE_FIELD, PERMISSION_SET_ARN_FIELD, PRINCIPAL_TYPE_FIELD, PRINCIPAL_ID_FIELD));
    private final String instanceArn;
    private final String targetId;
    private final String targetType;
    private final String permissionSetArn;
    private final String principalType;
    private final String principalId;

    private DeleteAccountAssignmentRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
        this.permissionSetArn = builder.permissionSetArn;
        this.principalType = builder.principalType;
        this.principalId = builder.principalId;
    }

    public String instanceArn() {
        return this.instanceArn;
    }

    public String targetId() {
        return this.targetId;
    }

    public TargetType targetType() {
        return TargetType.fromValue(this.targetType);
    }

    public String targetTypeAsString() {
        return this.targetType;
    }

    public String permissionSetArn() {
        return this.permissionSetArn;
    }

    public PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public String principalTypeAsString() {
        return this.principalType;
    }

    public String principalId() {
        return this.principalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAccountAssignmentRequest)) {
            return false;
        }
        DeleteAccountAssignmentRequest other = (DeleteAccountAssignmentRequest)((Object)obj);
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.permissionSetArn(), other.permissionSetArn()) && Objects.equals(this.principalTypeAsString(), other.principalTypeAsString()) && Objects.equals(this.principalId(), other.principalId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteAccountAssignmentRequest").add("InstanceArn", (Object)this.instanceArn()).add("TargetId", (Object)this.targetId()).add("TargetType", (Object)this.targetTypeAsString()).add("PermissionSetArn", (Object)this.permissionSetArn()).add("PrincipalType", (Object)this.principalTypeAsString()).add("PrincipalId", (Object)this.principalId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "PermissionSetArn": {
                return Optional.ofNullable(clazz.cast(this.permissionSetArn()));
            }
            case "PrincipalType": {
                return Optional.ofNullable(clazz.cast(this.principalTypeAsString()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAccountAssignmentRequest, T> g) {
        return obj -> g.apply((DeleteAccountAssignmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String instanceArn;
        private String targetId;
        private String targetType;
        private String permissionSetArn;
        private String principalType;
        private String principalId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAccountAssignmentRequest model) {
            super(model);
            this.instanceArn(model.instanceArn);
            this.targetId(model.targetId);
            this.targetType(model.targetType);
            this.permissionSetArn(model.permissionSetArn);
            this.principalType(model.principalType);
            this.principalId(model.principalId);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getPermissionSetArn() {
            return this.permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAccountAssignmentRequest build() {
            return new DeleteAccountAssignmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAccountAssignmentRequest> {
        public Builder instanceArn(String var1);

        public Builder targetId(String var1);

        public Builder targetType(String var1);

        public Builder targetType(TargetType var1);

        public Builder permissionSetArn(String var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);

        public Builder principalId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

