/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapAsyncClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.ListOperationEventsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListOperationEventsResponse;
import software.amazon.awssdk.services.ssmsap.model.OperationEvent;

public class ListOperationEventsPublisher
implements SdkPublisher<ListOperationEventsResponse> {
    private final SsmSapAsyncClient client;
    private final ListOperationEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOperationEventsPublisher(SsmSapAsyncClient client, ListOperationEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOperationEventsPublisher(SsmSapAsyncClient client, ListOperationEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOperationEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOperationEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OperationEvent> operationEvents() {
        Function<ListOperationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.operationEvents() != null) {
                return response.operationEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOperationEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOperationEventsResponseFetcher
    implements AsyncPageFetcher<ListOperationEventsResponse> {
        private ListOperationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListOperationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOperationEventsResponse> nextPage(ListOperationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListOperationEventsPublisher.this.client.listOperationEvents(ListOperationEventsPublisher.this.firstRequest);
            }
            return ListOperationEventsPublisher.this.client.listOperationEvents((ListOperationEventsRequest)((Object)ListOperationEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

