/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.PermissionActionType;
import software.amazon.awssdk.services.ssmsap.model.SsmSapRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteResourcePermissionRequest
extends SsmSapRequest
implements ToCopyableBuilder<Builder, DeleteResourcePermissionRequest> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(DeleteResourcePermissionRequest.getter(DeleteResourcePermissionRequest::actionTypeAsString)).setter(DeleteResourcePermissionRequest.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceResourceArn").getter(DeleteResourcePermissionRequest.getter(DeleteResourcePermissionRequest::sourceResourceArn)).setter(DeleteResourcePermissionRequest.setter(Builder::sourceResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DeleteResourcePermissionRequest.getter(DeleteResourcePermissionRequest::resourceArn)).setter(DeleteResourcePermissionRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD, SOURCE_RESOURCE_ARN_FIELD, RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteResourcePermissionRequest.memberNameToFieldInitializer();
    private final String actionType;
    private final String sourceResourceArn;
    private final String resourceArn;

    private DeleteResourcePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.actionType = builder.actionType;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.resourceArn = builder.resourceArn;
    }

    public final PermissionActionType actionType() {
        return PermissionActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final String sourceResourceArn() {
        return this.sourceResourceArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourcePermissionRequest)) {
            return false;
        }
        DeleteResourcePermissionRequest other = (DeleteResourcePermissionRequest)((Object)obj);
        return Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.sourceResourceArn(), other.sourceResourceArn()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteResourcePermissionRequest").add("ActionType", (Object)this.actionTypeAsString()).add("SourceResourceArn", (Object)this.sourceResourceArn()).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "SourceResourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceResourceArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("SourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourcePermissionRequest, T> g) {
        return obj -> g.apply((DeleteResourcePermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapRequest.BuilderImpl
    implements Builder {
        private String actionType;
        private String sourceResourceArn;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourcePermissionRequest model) {
            super(model);
            this.actionType(model.actionType);
            this.sourceResourceArn(model.sourceResourceArn);
            this.resourceArn(model.resourceArn);
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(PermissionActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getSourceResourceArn() {
            return this.sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteResourcePermissionRequest build() {
            return new DeleteResourcePermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmSapRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteResourcePermissionRequest> {
        public Builder actionType(String var1);

        public Builder actionType(PermissionActionType var1);

        public Builder sourceResourceArn(String var1);

        public Builder resourceArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

