/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.CredentialType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationCredential
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationCredential> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(ApplicationCredential.getter(ApplicationCredential::databaseName)).setter(ApplicationCredential.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> CREDENTIAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CredentialType").getter(ApplicationCredential.getter(ApplicationCredential::credentialTypeAsString)).setter(ApplicationCredential.setter(Builder::credentialType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialType").build()}).build();
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretId").getter(ApplicationCredential.getter(ApplicationCredential::secretId)).setter(ApplicationCredential.setter(Builder::secretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, CREDENTIAL_TYPE_FIELD, SECRET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String credentialType;
    private final String secretId;

    private ApplicationCredential(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.credentialType = builder.credentialType;
        this.secretId = builder.secretId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final CredentialType credentialType() {
        return CredentialType.fromValue(this.credentialType);
    }

    public final String credentialTypeAsString() {
        return this.credentialType;
    }

    public final String secretId() {
        return this.secretId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationCredential)) {
            return false;
        }
        ApplicationCredential other = (ApplicationCredential)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.credentialTypeAsString(), other.credentialTypeAsString()) && Objects.equals(this.secretId(), other.secretId());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationCredential").add("DatabaseName", (Object)this.databaseName()).add("CredentialType", (Object)this.credentialTypeAsString()).add("SecretId", (Object)(this.secretId() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "CredentialType": {
                return Optional.ofNullable(clazz.cast(this.credentialTypeAsString()));
            }
            case "SecretId": {
                return Optional.ofNullable(clazz.cast(this.secretId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationCredential, T> g) {
        return obj -> g.apply((ApplicationCredential)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private String credentialType;
        private String secretId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationCredential model) {
            this.databaseName(model.databaseName);
            this.credentialType(model.credentialType);
            this.secretId(model.secretId);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getCredentialType() {
            return this.credentialType;
        }

        public final void setCredentialType(String credentialType) {
            this.credentialType = credentialType;
        }

        @Override
        public final Builder credentialType(String credentialType) {
            this.credentialType = credentialType;
            return this;
        }

        @Override
        public final Builder credentialType(CredentialType credentialType) {
            this.credentialType(credentialType == null ? null : credentialType.toString());
            return this;
        }

        public final String getSecretId() {
            return this.secretId;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public ApplicationCredential build() {
            return new ApplicationCredential(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationCredential> {
        public Builder databaseName(String var1);

        public Builder credentialType(String var1);

        public Builder credentialType(CredentialType var1);

        public Builder secretId(String var1);
    }
}

