/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatabaseStatus {
    RUNNING("RUNNING"),
    STARTING("STARTING"),
    STOPPED("STOPPED"),
    WARNING("WARNING"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatabaseStatus> VALUE_MAP;
    private final String value;

    private DatabaseStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatabaseStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatabaseStatus> knownValues() {
        EnumSet<DatabaseStatus> knownValues = EnumSet.allOf(DatabaseStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatabaseStatus.class, DatabaseStatus::toString);
    }
}

