/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociationExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociationExecution> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecution.getter(AssociationExecution::associationId)).setter(AssociationExecution.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecution.getter(AssociationExecution::associationVersion)).setter(AssociationExecution.setter(Builder::associationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecution.getter(AssociationExecution::executionId)).setter(AssociationExecution.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecution.getter(AssociationExecution::status)).setter(AssociationExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecution.getter(AssociationExecution::detailedStatus)).setter(AssociationExecution.setter(Builder::detailedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AssociationExecution.getter(AssociationExecution::createdTime)).setter(AssociationExecution.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AssociationExecution.getter(AssociationExecution::lastExecutionDate)).setter(AssociationExecution.setter(Builder::lastExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionDate").build()}).build();
    private static final SdkField<String> RESOURCE_COUNT_BY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociationExecution.getter(AssociationExecution::resourceCountByStatus)).setter(AssociationExecution.setter(Builder::resourceCountByStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCountByStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, ASSOCIATION_VERSION_FIELD, EXECUTION_ID_FIELD, STATUS_FIELD, DETAILED_STATUS_FIELD, CREATED_TIME_FIELD, LAST_EXECUTION_DATE_FIELD, RESOURCE_COUNT_BY_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String associationVersion;
    private final String executionId;
    private final String status;
    private final String detailedStatus;
    private final Instant createdTime;
    private final Instant lastExecutionDate;
    private final String resourceCountByStatus;

    private AssociationExecution(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.associationVersion = builder.associationVersion;
        this.executionId = builder.executionId;
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.createdTime = builder.createdTime;
        this.lastExecutionDate = builder.lastExecutionDate;
        this.resourceCountByStatus = builder.resourceCountByStatus;
    }

    public String associationId() {
        return this.associationId;
    }

    public String associationVersion() {
        return this.associationVersion;
    }

    public String executionId() {
        return this.executionId;
    }

    public String status() {
        return this.status;
    }

    public String detailedStatus() {
        return this.detailedStatus;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Instant lastExecutionDate() {
        return this.lastExecutionDate;
    }

    public String resourceCountByStatus() {
        return this.resourceCountByStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCountByStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationExecution)) {
            return false;
        }
        AssociationExecution other = (AssociationExecution)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.associationVersion(), other.associationVersion()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.detailedStatus(), other.detailedStatus()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastExecutionDate(), other.lastExecutionDate()) && Objects.equals(this.resourceCountByStatus(), other.resourceCountByStatus());
    }

    public String toString() {
        return ToString.builder((String)"AssociationExecution").add("AssociationId", (Object)this.associationId()).add("AssociationVersion", (Object)this.associationVersion()).add("ExecutionId", (Object)this.executionId()).add("Status", (Object)this.status()).add("DetailedStatus", (Object)this.detailedStatus()).add("CreatedTime", (Object)this.createdTime()).add("LastExecutionDate", (Object)this.lastExecutionDate()).add("ResourceCountByStatus", (Object)this.resourceCountByStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "AssociationVersion": {
                return Optional.ofNullable(clazz.cast(this.associationVersion()));
            }
            case "ExecutionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "DetailedStatus": {
                return Optional.ofNullable(clazz.cast(this.detailedStatus()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastExecutionDate()));
            }
            case "ResourceCountByStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceCountByStatus()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationExecution, T> g) {
        return obj -> g.apply((AssociationExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String associationVersion;
        private String executionId;
        private String status;
        private String detailedStatus;
        private Instant createdTime;
        private Instant lastExecutionDate;
        private String resourceCountByStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationExecution model) {
            this.associationId(model.associationId);
            this.associationVersion(model.associationVersion);
            this.executionId(model.executionId);
            this.status(model.status);
            this.detailedStatus(model.detailedStatus);
            this.createdTime(model.createdTime);
            this.lastExecutionDate(model.lastExecutionDate);
            this.resourceCountByStatus(model.resourceCountByStatus);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getAssociationVersion() {
            return this.associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastExecutionDate() {
            return this.lastExecutionDate;
        }

        @Override
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        public final String getResourceCountByStatus() {
            return this.resourceCountByStatus;
        }

        @Override
        public final Builder resourceCountByStatus(String resourceCountByStatus) {
            this.resourceCountByStatus = resourceCountByStatus;
            return this;
        }

        public final void setResourceCountByStatus(String resourceCountByStatus) {
            this.resourceCountByStatus = resourceCountByStatus;
        }

        public AssociationExecution build() {
            return new AssociationExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociationExecution> {
        public Builder associationId(String var1);

        public Builder associationVersion(String var1);

        public Builder executionId(String var1);

        public Builder status(String var1);

        public Builder detailedStatus(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastExecutionDate(Instant var1);

        public Builder resourceCountByStatus(String var1);
    }
}

