/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.DocumentDescription;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDocumentResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeDocumentResponse> {
    private static final SdkField<DocumentDescription> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeDocumentResponse.getter(DescribeDocumentResponse::document)).setter(DescribeDocumentResponse.setter(Builder::document)).constructor(DocumentDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD));
    private final DocumentDescription document;

    private DescribeDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.document = builder.document;
    }

    public DocumentDescription document() {
        return this.document;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentResponse)) {
            return false;
        }
        DescribeDocumentResponse other = (DescribeDocumentResponse)((Object)obj);
        return Objects.equals(this.document(), other.document());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDocumentResponse").add("Document", (Object)this.document()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDocumentResponse, T> g) {
        return obj -> g.apply((DescribeDocumentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private DocumentDescription document;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentResponse model) {
            super(model);
            this.document(model.document);
        }

        public final DocumentDescription.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        @Override
        public final Builder document(DocumentDescription document) {
            this.document = document;
            return this;
        }

        public final void setDocument(DocumentDescription.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public DescribeDocumentResponse build() {
            return new DescribeDocumentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDocumentResponse> {
        public Builder document(DocumentDescription var1);

        default public Builder document(Consumer<DocumentDescription.Builder> document) {
            return this.document((DocumentDescription)((DocumentDescription.Builder)DocumentDescription.builder().applyMutation(document)).build());
        }
    }
}

