/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceSettingRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, UpdateServiceSettingRequest> {
    private static final SdkField<String> SETTING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateServiceSettingRequest.getter(UpdateServiceSettingRequest::settingId)).setter(UpdateServiceSettingRequest.setter(Builder::settingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingId").build()}).build();
    private static final SdkField<String> SETTING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateServiceSettingRequest.getter(UpdateServiceSettingRequest::settingValue)).setter(UpdateServiceSettingRequest.setter(Builder::settingValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SETTING_ID_FIELD, SETTING_VALUE_FIELD));
    private final String settingId;
    private final String settingValue;

    private UpdateServiceSettingRequest(BuilderImpl builder) {
        super(builder);
        this.settingId = builder.settingId;
        this.settingValue = builder.settingValue;
    }

    public String settingId() {
        return this.settingId;
    }

    public String settingValue() {
        return this.settingValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.settingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.settingValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceSettingRequest)) {
            return false;
        }
        UpdateServiceSettingRequest other = (UpdateServiceSettingRequest)((Object)obj);
        return Objects.equals(this.settingId(), other.settingId()) && Objects.equals(this.settingValue(), other.settingValue());
    }

    public String toString() {
        return ToString.builder((String)"UpdateServiceSettingRequest").add("SettingId", (Object)this.settingId()).add("SettingValue", (Object)this.settingValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SettingId": {
                return Optional.ofNullable(clazz.cast(this.settingId()));
            }
            case "SettingValue": {
                return Optional.ofNullable(clazz.cast(this.settingValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceSettingRequest, T> g) {
        return obj -> g.apply((UpdateServiceSettingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String settingId;
        private String settingValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceSettingRequest model) {
            super(model);
            this.settingId(model.settingId);
            this.settingValue(model.settingValue);
        }

        public final String getSettingId() {
            return this.settingId;
        }

        @Override
        public final Builder settingId(String settingId) {
            this.settingId = settingId;
            return this;
        }

        public final void setSettingId(String settingId) {
            this.settingId = settingId;
        }

        public final String getSettingValue() {
            return this.settingValue;
        }

        @Override
        public final Builder settingValue(String settingValue) {
            this.settingValue = settingValue;
            return this;
        }

        public final void setSettingValue(String settingValue) {
            this.settingValue = settingValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceSettingRequest build() {
            return new UpdateServiceSettingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceSettingRequest> {
        public Builder settingId(String var1);

        public Builder settingValue(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

