/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AttachmentInformation;
import software.amazon.awssdk.services.ssm.model.AttachmentInformationListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentFormat;
import software.amazon.awssdk.services.ssm.model.DocumentHashType;
import software.amazon.awssdk.services.ssm.model.DocumentParameter;
import software.amazon.awssdk.services.ssm.model.DocumentParameterListCopier;
import software.amazon.awssdk.services.ssm.model.DocumentStatus;
import software.amazon.awssdk.services.ssm.model.DocumentType;
import software.amazon.awssdk.services.ssm.model.PlatformType;
import software.amazon.awssdk.services.ssm.model.PlatformTypeListCopier;
import software.amazon.awssdk.services.ssm.model.Tag;
import software.amazon.awssdk.services.ssm.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentDescription> {
    private static final SdkField<String> SHA1_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::sha1)).setter(DocumentDescription.setter(Builder::sha1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sha1").build()}).build();
    private static final SdkField<String> HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::hash)).setter(DocumentDescription.setter(Builder::hash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hash").build()}).build();
    private static final SdkField<String> HASH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::hashTypeAsString)).setter(DocumentDescription.setter(Builder::hashType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HashType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::name)).setter(DocumentDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::versionName)).setter(DocumentDescription.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::owner)).setter(DocumentDescription.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DocumentDescription.getter(DocumentDescription::createdDate)).setter(DocumentDescription.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::statusAsString)).setter(DocumentDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::statusInformation)).setter(DocumentDescription.setter(Builder::statusInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusInformation").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::documentVersion)).setter(DocumentDescription.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::description)).setter(DocumentDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<DocumentParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DocumentDescription.getter(DocumentDescription::parameters)).setter(DocumentDescription.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PLATFORM_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DocumentDescription.getter(DocumentDescription::platformTypesAsStrings)).setter(DocumentDescription.setter(Builder::platformTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::documentTypeAsString)).setter(DocumentDescription.setter(Builder::documentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::schemaVersion)).setter(DocumentDescription.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()}).build();
    private static final SdkField<String> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::latestVersion)).setter(DocumentDescription.setter(Builder::latestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").build()}).build();
    private static final SdkField<String> DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::defaultVersion)).setter(DocumentDescription.setter(Builder::defaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersion").build()}).build();
    private static final SdkField<String> DOCUMENT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::documentFormatAsString)).setter(DocumentDescription.setter(Builder::documentFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFormat").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentDescription.getter(DocumentDescription::targetType)).setter(DocumentDescription.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DocumentDescription.getter(DocumentDescription::tags)).setter(DocumentDescription.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttachmentInformation>> ATTACHMENTS_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DocumentDescription.getter(DocumentDescription::attachmentsInformation)).setter(DocumentDescription.setter(Builder::attachmentsInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentsInformation").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHA1_FIELD, HASH_FIELD, HASH_TYPE_FIELD, NAME_FIELD, VERSION_NAME_FIELD, OWNER_FIELD, CREATED_DATE_FIELD, STATUS_FIELD, STATUS_INFORMATION_FIELD, DOCUMENT_VERSION_FIELD, DESCRIPTION_FIELD, PARAMETERS_FIELD, PLATFORM_TYPES_FIELD, DOCUMENT_TYPE_FIELD, SCHEMA_VERSION_FIELD, LATEST_VERSION_FIELD, DEFAULT_VERSION_FIELD, DOCUMENT_FORMAT_FIELD, TARGET_TYPE_FIELD, TAGS_FIELD, ATTACHMENTS_INFORMATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sha1;
    private final String hash;
    private final String hashType;
    private final String name;
    private final String versionName;
    private final String owner;
    private final Instant createdDate;
    private final String status;
    private final String statusInformation;
    private final String documentVersion;
    private final String description;
    private final List<DocumentParameter> parameters;
    private final List<String> platformTypes;
    private final String documentType;
    private final String schemaVersion;
    private final String latestVersion;
    private final String defaultVersion;
    private final String documentFormat;
    private final String targetType;
    private final List<Tag> tags;
    private final List<AttachmentInformation> attachmentsInformation;

    private DocumentDescription(BuilderImpl builder) {
        this.sha1 = builder.sha1;
        this.hash = builder.hash;
        this.hashType = builder.hashType;
        this.name = builder.name;
        this.versionName = builder.versionName;
        this.owner = builder.owner;
        this.createdDate = builder.createdDate;
        this.status = builder.status;
        this.statusInformation = builder.statusInformation;
        this.documentVersion = builder.documentVersion;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.platformTypes = builder.platformTypes;
        this.documentType = builder.documentType;
        this.schemaVersion = builder.schemaVersion;
        this.latestVersion = builder.latestVersion;
        this.defaultVersion = builder.defaultVersion;
        this.documentFormat = builder.documentFormat;
        this.targetType = builder.targetType;
        this.tags = builder.tags;
        this.attachmentsInformation = builder.attachmentsInformation;
    }

    public String sha1() {
        return this.sha1;
    }

    public String hash() {
        return this.hash;
    }

    public DocumentHashType hashType() {
        return DocumentHashType.fromValue(this.hashType);
    }

    public String hashTypeAsString() {
        return this.hashType;
    }

    public String name() {
        return this.name;
    }

    public String versionName() {
        return this.versionName;
    }

    public String owner() {
        return this.owner;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public DocumentStatus status() {
        return DocumentStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusInformation() {
        return this.statusInformation;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public String description() {
        return this.description;
    }

    public List<DocumentParameter> parameters() {
        return this.parameters;
    }

    public List<PlatformType> platformTypes() {
        return PlatformTypeListCopier.copyStringToEnum(this.platformTypes);
    }

    public List<String> platformTypesAsStrings() {
        return this.platformTypes;
    }

    public DocumentType documentType() {
        return DocumentType.fromValue(this.documentType);
    }

    public String documentTypeAsString() {
        return this.documentType;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public String latestVersion() {
        return this.latestVersion;
    }

    public String defaultVersion() {
        return this.defaultVersion;
    }

    public DocumentFormat documentFormat() {
        return DocumentFormat.fromValue(this.documentFormat);
    }

    public String documentFormatAsString() {
        return this.documentFormat;
    }

    public String targetType() {
        return this.targetType;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<AttachmentInformation> attachmentsInformation() {
        return this.attachmentsInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sha1());
        hashCode = 31 * hashCode + Objects.hashCode(this.hash());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentsInformation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentDescription)) {
            return false;
        }
        DocumentDescription other = (DocumentDescription)obj;
        return Objects.equals(this.sha1(), other.sha1()) && Objects.equals(this.hash(), other.hash()) && Objects.equals(this.hashTypeAsString(), other.hashTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusInformation(), other.statusInformation()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.platformTypesAsStrings(), other.platformTypesAsStrings()) && Objects.equals(this.documentTypeAsString(), other.documentTypeAsString()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.defaultVersion(), other.defaultVersion()) && Objects.equals(this.documentFormatAsString(), other.documentFormatAsString()) && Objects.equals(this.targetType(), other.targetType()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.attachmentsInformation(), other.attachmentsInformation());
    }

    public String toString() {
        return ToString.builder((String)"DocumentDescription").add("Sha1", (Object)this.sha1()).add("Hash", (Object)this.hash()).add("HashType", (Object)this.hashTypeAsString()).add("Name", (Object)this.name()).add("VersionName", (Object)this.versionName()).add("Owner", (Object)this.owner()).add("CreatedDate", (Object)this.createdDate()).add("Status", (Object)this.statusAsString()).add("StatusInformation", (Object)this.statusInformation()).add("DocumentVersion", (Object)this.documentVersion()).add("Description", (Object)this.description()).add("Parameters", this.parameters()).add("PlatformTypes", this.platformTypesAsStrings()).add("DocumentType", (Object)this.documentTypeAsString()).add("SchemaVersion", (Object)this.schemaVersion()).add("LatestVersion", (Object)this.latestVersion()).add("DefaultVersion", (Object)this.defaultVersion()).add("DocumentFormat", (Object)this.documentFormatAsString()).add("TargetType", (Object)this.targetType()).add("Tags", this.tags()).add("AttachmentsInformation", this.attachmentsInformation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sha1": {
                return Optional.ofNullable(clazz.cast(this.sha1()));
            }
            case "Hash": {
                return Optional.ofNullable(clazz.cast(this.hash()));
            }
            case "HashType": {
                return Optional.ofNullable(clazz.cast(this.hashTypeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "VersionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusInformation": {
                return Optional.ofNullable(clazz.cast(this.statusInformation()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "PlatformTypes": {
                return Optional.ofNullable(clazz.cast(this.platformTypesAsStrings()));
            }
            case "DocumentType": {
                return Optional.ofNullable(clazz.cast(this.documentTypeAsString()));
            }
            case "SchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "LatestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "DefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.defaultVersion()));
            }
            case "DocumentFormat": {
                return Optional.ofNullable(clazz.cast(this.documentFormatAsString()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetType()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AttachmentsInformation": {
                return Optional.ofNullable(clazz.cast(this.attachmentsInformation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentDescription, T> g) {
        return obj -> g.apply((DocumentDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sha1;
        private String hash;
        private String hashType;
        private String name;
        private String versionName;
        private String owner;
        private Instant createdDate;
        private String status;
        private String statusInformation;
        private String documentVersion;
        private String description;
        private List<DocumentParameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> platformTypes = DefaultSdkAutoConstructList.getInstance();
        private String documentType;
        private String schemaVersion;
        private String latestVersion;
        private String defaultVersion;
        private String documentFormat;
        private String targetType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<AttachmentInformation> attachmentsInformation = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentDescription model) {
            this.sha1(model.sha1);
            this.hash(model.hash);
            this.hashType(model.hashType);
            this.name(model.name);
            this.versionName(model.versionName);
            this.owner(model.owner);
            this.createdDate(model.createdDate);
            this.status(model.status);
            this.statusInformation(model.statusInformation);
            this.documentVersion(model.documentVersion);
            this.description(model.description);
            this.parameters(model.parameters);
            this.platformTypesWithStrings(model.platformTypes);
            this.documentType(model.documentType);
            this.schemaVersion(model.schemaVersion);
            this.latestVersion(model.latestVersion);
            this.defaultVersion(model.defaultVersion);
            this.documentFormat(model.documentFormat);
            this.targetType(model.targetType);
            this.tags(model.tags);
            this.attachmentsInformation(model.attachmentsInformation);
        }

        public final String getSha1() {
            return this.sha1;
        }

        @Override
        public final Builder sha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        public final void setSha1(String sha1) {
            this.sha1 = sha1;
        }

        public final String getHash() {
            return this.hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        public final String getHashTypeAsString() {
            return this.hashType;
        }

        @Override
        public final Builder hashType(String hashType) {
            this.hashType = hashType;
            return this;
        }

        @Override
        public final Builder hashType(DocumentHashType hashType) {
            this.hashType(hashType == null ? null : hashType.toString());
            return this;
        }

        public final void setHashType(String hashType) {
            this.hashType = hashType;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusInformation() {
            return this.statusInformation;
        }

        @Override
        public final Builder statusInformation(String statusInformation) {
            this.statusInformation = statusInformation;
            return this;
        }

        public final void setStatusInformation(String statusInformation) {
            this.statusInformation = statusInformation;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DocumentParameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(DocumentParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<DocumentParameter> parameters) {
            this.parameters = DocumentParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(DocumentParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<DocumentParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (DocumentParameter)((DocumentParameter.Builder)DocumentParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<DocumentParameter.BuilderImpl> parameters) {
            this.parameters = DocumentParameterListCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getPlatformTypesAsStrings() {
            return this.platformTypes;
        }

        @Override
        public final Builder platformTypesWithStrings(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypesWithStrings(String ... platformTypes) {
            this.platformTypesWithStrings(Arrays.asList(platformTypes));
            return this;
        }

        @Override
        public final Builder platformTypes(Collection<PlatformType> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copyEnumToString(platformTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformTypes(PlatformType ... platformTypes) {
            this.platformTypes(Arrays.asList(platformTypes));
            return this;
        }

        public final void setPlatformTypesWithStrings(Collection<String> platformTypes) {
            this.platformTypes = PlatformTypeListCopier.copy(platformTypes);
        }

        public final String getDocumentTypeAsString() {
            return this.documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType == null ? null : documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        public final String getDefaultVersion() {
            return this.defaultVersion;
        }

        @Override
        public final Builder defaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final void setDefaultVersion(String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public final String getDocumentFormatAsString() {
            return this.documentFormat;
        }

        @Override
        public final Builder documentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
            return this;
        }

        @Override
        public final Builder documentFormat(DocumentFormat documentFormat) {
            this.documentFormat(documentFormat == null ? null : documentFormat.toString());
            return this;
        }

        public final void setDocumentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<AttachmentInformation.Builder> getAttachmentsInformation() {
            return this.attachmentsInformation != null ? (Collection)this.attachmentsInformation.stream().map(AttachmentInformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachmentsInformation(Collection<AttachmentInformation> attachmentsInformation) {
            this.attachmentsInformation = AttachmentInformationListCopier.copy(attachmentsInformation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentsInformation(AttachmentInformation ... attachmentsInformation) {
            this.attachmentsInformation(Arrays.asList(attachmentsInformation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentsInformation(Consumer<AttachmentInformation.Builder> ... attachmentsInformation) {
            this.attachmentsInformation(Stream.of(attachmentsInformation).map(c -> (AttachmentInformation)((AttachmentInformation.Builder)AttachmentInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachmentsInformation(Collection<AttachmentInformation.BuilderImpl> attachmentsInformation) {
            this.attachmentsInformation = AttachmentInformationListCopier.copyFromBuilder(attachmentsInformation);
        }

        public DocumentDescription build() {
            return new DocumentDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentDescription> {
        public Builder sha1(String var1);

        public Builder hash(String var1);

        public Builder hashType(String var1);

        public Builder hashType(DocumentHashType var1);

        public Builder name(String var1);

        public Builder versionName(String var1);

        public Builder owner(String var1);

        public Builder createdDate(Instant var1);

        public Builder status(String var1);

        public Builder status(DocumentStatus var1);

        public Builder statusInformation(String var1);

        public Builder documentVersion(String var1);

        public Builder description(String var1);

        public Builder parameters(Collection<DocumentParameter> var1);

        public Builder parameters(DocumentParameter ... var1);

        public Builder parameters(Consumer<DocumentParameter.Builder> ... var1);

        public Builder platformTypesWithStrings(Collection<String> var1);

        public Builder platformTypesWithStrings(String ... var1);

        public Builder platformTypes(Collection<PlatformType> var1);

        public Builder platformTypes(PlatformType ... var1);

        public Builder documentType(String var1);

        public Builder documentType(DocumentType var1);

        public Builder schemaVersion(String var1);

        public Builder latestVersion(String var1);

        public Builder defaultVersion(String var1);

        public Builder documentFormat(String var1);

        public Builder documentFormat(DocumentFormat var1);

        public Builder targetType(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder attachmentsInformation(Collection<AttachmentInformation> var1);

        public Builder attachmentsInformation(AttachmentInformation ... var1);

        public Builder attachmentsInformation(Consumer<AttachmentInformation.Builder> ... var1);
    }
}

