/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem;
import software.amazon.awssdk.services.ssm.model.InventoryDeletionsListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInventoryDeletionsResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeInventoryDeletionsResponse> {
    private static final SdkField<List<InventoryDeletionStatusItem>> INVENTORY_DELETIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeInventoryDeletionsResponse.getter(DescribeInventoryDeletionsResponse::inventoryDeletions)).setter(DescribeInventoryDeletionsResponse.setter(Builder::inventoryDeletions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InventoryDeletions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InventoryDeletionStatusItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeInventoryDeletionsResponse.getter(DescribeInventoryDeletionsResponse::nextToken)).setter(DescribeInventoryDeletionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVENTORY_DELETIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<InventoryDeletionStatusItem> inventoryDeletions;
    private final String nextToken;

    private DescribeInventoryDeletionsResponse(BuilderImpl builder) {
        super(builder);
        this.inventoryDeletions = builder.inventoryDeletions;
        this.nextToken = builder.nextToken;
    }

    public List<InventoryDeletionStatusItem> inventoryDeletions() {
        return this.inventoryDeletions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inventoryDeletions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInventoryDeletionsResponse)) {
            return false;
        }
        DescribeInventoryDeletionsResponse other = (DescribeInventoryDeletionsResponse)((Object)obj);
        return Objects.equals(this.inventoryDeletions(), other.inventoryDeletions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInventoryDeletionsResponse").add("InventoryDeletions", this.inventoryDeletions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InventoryDeletions": {
                return Optional.ofNullable(clazz.cast(this.inventoryDeletions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInventoryDeletionsResponse, T> g) {
        return obj -> g.apply((DescribeInventoryDeletionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<InventoryDeletionStatusItem> inventoryDeletions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInventoryDeletionsResponse model) {
            super(model);
            this.inventoryDeletions(model.inventoryDeletions);
            this.nextToken(model.nextToken);
        }

        public final Collection<InventoryDeletionStatusItem.Builder> getInventoryDeletions() {
            return this.inventoryDeletions != null ? (Collection)this.inventoryDeletions.stream().map(InventoryDeletionStatusItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inventoryDeletions(Collection<InventoryDeletionStatusItem> inventoryDeletions) {
            this.inventoryDeletions = InventoryDeletionsListCopier.copy(inventoryDeletions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inventoryDeletions(InventoryDeletionStatusItem ... inventoryDeletions) {
            this.inventoryDeletions(Arrays.asList(inventoryDeletions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inventoryDeletions(Consumer<InventoryDeletionStatusItem.Builder> ... inventoryDeletions) {
            this.inventoryDeletions(Stream.of(inventoryDeletions).map(c -> (InventoryDeletionStatusItem)((InventoryDeletionStatusItem.Builder)InventoryDeletionStatusItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInventoryDeletions(Collection<InventoryDeletionStatusItem.BuilderImpl> inventoryDeletions) {
            this.inventoryDeletions = InventoryDeletionsListCopier.copyFromBuilder(inventoryDeletions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInventoryDeletionsResponse build() {
            return new DescribeInventoryDeletionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInventoryDeletionsResponse> {
        public Builder inventoryDeletions(Collection<InventoryDeletionStatusItem> var1);

        public Builder inventoryDeletions(InventoryDeletionStatusItem ... var1);

        public Builder inventoryDeletions(Consumer<InventoryDeletionStatusItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

