/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMaintenanceWindowResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetMaintenanceWindowResponse> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::windowId)).setter(GetMaintenanceWindowResponse.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::name)).setter(GetMaintenanceWindowResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::description)).setter(GetMaintenanceWindowResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::startDate)).setter(GetMaintenanceWindowResponse.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()}).build();
    private static final SdkField<String> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::endDate)).setter(GetMaintenanceWindowResponse.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::schedule)).setter(GetMaintenanceWindowResponse.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> SCHEDULE_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::scheduleTimezone)).setter(GetMaintenanceWindowResponse.setter(Builder::scheduleTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleTimezone").build()}).build();
    private static final SdkField<String> NEXT_EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::nextExecutionTime)).setter(GetMaintenanceWindowResponse.setter(Builder::nextExecutionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextExecutionTime").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::duration)).setter(GetMaintenanceWindowResponse.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Integer> CUTOFF_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::cutoff)).setter(GetMaintenanceWindowResponse.setter(Builder::cutoff)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cutoff").build()}).build();
    private static final SdkField<Boolean> ALLOW_UNASSOCIATED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::allowUnassociatedTargets)).setter(GetMaintenanceWindowResponse.setter(Builder::allowUnassociatedTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUnassociatedTargets").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::enabled)).setter(GetMaintenanceWindowResponse.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::createdDate)).setter(GetMaintenanceWindowResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<Instant> MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetMaintenanceWindowResponse.getter(GetMaintenanceWindowResponse::modifiedDate)).setter(GetMaintenanceWindowResponse.setter(Builder::modifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, START_DATE_FIELD, END_DATE_FIELD, SCHEDULE_FIELD, SCHEDULE_TIMEZONE_FIELD, NEXT_EXECUTION_TIME_FIELD, DURATION_FIELD, CUTOFF_FIELD, ALLOW_UNASSOCIATED_TARGETS_FIELD, ENABLED_FIELD, CREATED_DATE_FIELD, MODIFIED_DATE_FIELD));
    private final String windowId;
    private final String name;
    private final String description;
    private final String startDate;
    private final String endDate;
    private final String schedule;
    private final String scheduleTimezone;
    private final String nextExecutionTime;
    private final Integer duration;
    private final Integer cutoff;
    private final Boolean allowUnassociatedTargets;
    private final Boolean enabled;
    private final Instant createdDate;
    private final Instant modifiedDate;

    private GetMaintenanceWindowResponse(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.description = builder.description;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.schedule = builder.schedule;
        this.scheduleTimezone = builder.scheduleTimezone;
        this.nextExecutionTime = builder.nextExecutionTime;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.allowUnassociatedTargets = builder.allowUnassociatedTargets;
        this.enabled = builder.enabled;
        this.createdDate = builder.createdDate;
        this.modifiedDate = builder.modifiedDate;
    }

    public String windowId() {
        return this.windowId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String startDate() {
        return this.startDate;
    }

    public String endDate() {
        return this.endDate;
    }

    public String schedule() {
        return this.schedule;
    }

    public String scheduleTimezone() {
        return this.scheduleTimezone;
    }

    public String nextExecutionTime() {
        return this.nextExecutionTime;
    }

    public Integer duration() {
        return this.duration;
    }

    public Integer cutoff() {
        return this.cutoff;
    }

    public Boolean allowUnassociatedTargets() {
        return this.allowUnassociatedTargets;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Instant modifiedDate() {
        return this.modifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextExecutionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowUnassociatedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowResponse)) {
            return false;
        }
        GetMaintenanceWindowResponse other = (GetMaintenanceWindowResponse)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.scheduleTimezone(), other.scheduleTimezone()) && Objects.equals(this.nextExecutionTime(), other.nextExecutionTime()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.cutoff(), other.cutoff()) && Objects.equals(this.allowUnassociatedTargets(), other.allowUnassociatedTargets()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.modifiedDate(), other.modifiedDate());
    }

    public String toString() {
        return ToString.builder((String)"GetMaintenanceWindowResponse").add("WindowId", (Object)this.windowId()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("Schedule", (Object)this.schedule()).add("ScheduleTimezone", (Object)this.scheduleTimezone()).add("NextExecutionTime", (Object)this.nextExecutionTime()).add("Duration", (Object)this.duration()).add("Cutoff", (Object)this.cutoff()).add("AllowUnassociatedTargets", (Object)this.allowUnassociatedTargets()).add("Enabled", (Object)this.enabled()).add("CreatedDate", (Object)this.createdDate()).add("ModifiedDate", (Object)this.modifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "StartDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "ScheduleTimezone": {
                return Optional.ofNullable(clazz.cast(this.scheduleTimezone()));
            }
            case "NextExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.nextExecutionTime()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Cutoff": {
                return Optional.ofNullable(clazz.cast(this.cutoff()));
            }
            case "AllowUnassociatedTargets": {
                return Optional.ofNullable(clazz.cast(this.allowUnassociatedTargets()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "ModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.modifiedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMaintenanceWindowResponse, T> g) {
        return obj -> g.apply((GetMaintenanceWindowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String windowId;
        private String name;
        private String description;
        private String startDate;
        private String endDate;
        private String schedule;
        private String scheduleTimezone;
        private String nextExecutionTime;
        private Integer duration;
        private Integer cutoff;
        private Boolean allowUnassociatedTargets;
        private Boolean enabled;
        private Instant createdDate;
        private Instant modifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowResponse model) {
            super(model);
            this.windowId(model.windowId);
            this.name(model.name);
            this.description(model.description);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.schedule(model.schedule);
            this.scheduleTimezone(model.scheduleTimezone);
            this.nextExecutionTime(model.nextExecutionTime);
            this.duration(model.duration);
            this.cutoff(model.cutoff);
            this.allowUnassociatedTargets(model.allowUnassociatedTargets);
            this.enabled(model.enabled);
            this.createdDate(model.createdDate);
            this.modifiedDate(model.modifiedDate);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public final String getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final String getScheduleTimezone() {
            return this.scheduleTimezone;
        }

        @Override
        public final Builder scheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
            return this;
        }

        public final void setScheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
        }

        public final String getNextExecutionTime() {
            return this.nextExecutionTime;
        }

        @Override
        public final Builder nextExecutionTime(String nextExecutionTime) {
            this.nextExecutionTime = nextExecutionTime;
            return this;
        }

        public final void setNextExecutionTime(String nextExecutionTime) {
            this.nextExecutionTime = nextExecutionTime;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getCutoff() {
            return this.cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        public final Boolean getAllowUnassociatedTargets() {
            return this.allowUnassociatedTargets;
        }

        @Override
        public final Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
            return this;
        }

        public final void setAllowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getModifiedDate() {
            return this.modifiedDate;
        }

        @Override
        public final Builder modifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
            return this;
        }

        public final void setModifiedDate(Instant modifiedDate) {
            this.modifiedDate = modifiedDate;
        }

        @Override
        public GetMaintenanceWindowResponse build() {
            return new GetMaintenanceWindowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMaintenanceWindowResponse> {
        public Builder windowId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder startDate(String var1);

        public Builder endDate(String var1);

        public Builder schedule(String var1);

        public Builder scheduleTimezone(String var1);

        public Builder nextExecutionTime(String var1);

        public Builder duration(Integer var1);

        public Builder cutoff(Integer var1);

        public Builder allowUnassociatedTargets(Boolean var1);

        public Builder enabled(Boolean var1);

        public Builder createdDate(Instant var1);

        public Builder modifiedDate(Instant var1);
    }
}

