/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeployablePatchSnapshotForInstanceResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeployablePatchSnapshotForInstanceResponse.getter(GetDeployablePatchSnapshotForInstanceResponse::instanceId)).setter(GetDeployablePatchSnapshotForInstanceResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeployablePatchSnapshotForInstanceResponse.getter(GetDeployablePatchSnapshotForInstanceResponse::snapshotId)).setter(GetDeployablePatchSnapshotForInstanceResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<String> SNAPSHOT_DOWNLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeployablePatchSnapshotForInstanceResponse.getter(GetDeployablePatchSnapshotForInstanceResponse::snapshotDownloadUrl)).setter(GetDeployablePatchSnapshotForInstanceResponse.setter(Builder::snapshotDownloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotDownloadUrl").build()}).build();
    private static final SdkField<String> PRODUCT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDeployablePatchSnapshotForInstanceResponse.getter(GetDeployablePatchSnapshotForInstanceResponse::product)).setter(GetDeployablePatchSnapshotForInstanceResponse.setter(Builder::product)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, SNAPSHOT_ID_FIELD, SNAPSHOT_DOWNLOAD_URL_FIELD, PRODUCT_FIELD));
    private final String instanceId;
    private final String snapshotId;
    private final String snapshotDownloadUrl;
    private final String product;

    private GetDeployablePatchSnapshotForInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.snapshotId = builder.snapshotId;
        this.snapshotDownloadUrl = builder.snapshotDownloadUrl;
        this.product = builder.product;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public String snapshotDownloadUrl() {
        return this.snapshotDownloadUrl;
    }

    public String product() {
        return this.product;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotDownloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.product());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeployablePatchSnapshotForInstanceResponse)) {
            return false;
        }
        GetDeployablePatchSnapshotForInstanceResponse other = (GetDeployablePatchSnapshotForInstanceResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.snapshotDownloadUrl(), other.snapshotDownloadUrl()) && Objects.equals(this.product(), other.product());
    }

    public String toString() {
        return ToString.builder((String)"GetDeployablePatchSnapshotForInstanceResponse").add("InstanceId", (Object)this.instanceId()).add("SnapshotId", (Object)this.snapshotId()).add("SnapshotDownloadUrl", (Object)this.snapshotDownloadUrl()).add("Product", (Object)this.product()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "SnapshotDownloadUrl": {
                return Optional.ofNullable(clazz.cast(this.snapshotDownloadUrl()));
            }
            case "Product": {
                return Optional.ofNullable(clazz.cast(this.product()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeployablePatchSnapshotForInstanceResponse, T> g) {
        return obj -> g.apply((GetDeployablePatchSnapshotForInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private String instanceId;
        private String snapshotId;
        private String snapshotDownloadUrl;
        private String product;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeployablePatchSnapshotForInstanceResponse model) {
            super(model);
            this.instanceId(model.instanceId);
            this.snapshotId(model.snapshotId);
            this.snapshotDownloadUrl(model.snapshotDownloadUrl);
            this.product(model.product);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getSnapshotDownloadUrl() {
            return this.snapshotDownloadUrl;
        }

        @Override
        public final Builder snapshotDownloadUrl(String snapshotDownloadUrl) {
            this.snapshotDownloadUrl = snapshotDownloadUrl;
            return this;
        }

        public final void setSnapshotDownloadUrl(String snapshotDownloadUrl) {
            this.snapshotDownloadUrl = snapshotDownloadUrl;
        }

        public final String getProduct() {
            return this.product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public GetDeployablePatchSnapshotForInstanceResponse build() {
            return new GetDeployablePatchSnapshotForInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeployablePatchSnapshotForInstanceResponse> {
        public Builder instanceId(String var1);

        public Builder snapshotId(String var1);

        public Builder snapshotDownloadUrl(String var1);

        public Builder product(String var1);
    }
}

