/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.Association;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;

public class ListAssociationsPublisher
implements SdkPublisher<ListAssociationsResponse> {
    private final SsmAsyncClient client;
    private final ListAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssociationsPublisher(SsmAsyncClient client, ListAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssociationsPublisher(SsmAsyncClient client, ListAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Association> associations() {
        return this.flatMapIterable(response -> response.associations());
    }

    private class ListAssociationsResponseFetcher
    implements AsyncPageFetcher<ListAssociationsResponse> {
        private ListAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssociationsResponse> nextPage(ListAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociationsPublisher.this.client.listAssociations(ListAssociationsPublisher.this.firstRequest);
            }
            return ListAssociationsPublisher.this.client.listAssociations((ListAssociationsRequest)((Object)ListAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

