/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse;
import software.amazon.awssdk.services.ssm.model.InventoryItemSchema;

public class GetInventorySchemaPublisher
implements SdkPublisher<GetInventorySchemaResponse> {
    private final SsmAsyncClient client;
    private final GetInventorySchemaRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetInventorySchemaPublisher(SsmAsyncClient client, GetInventorySchemaRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetInventorySchemaPublisher(SsmAsyncClient client, GetInventorySchemaRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetInventorySchemaResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetInventorySchemaResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InventoryItemSchema> schemas() {
        return this.flatMapIterable(response -> response.schemas());
    }

    private class GetInventorySchemaResponseFetcher
    implements AsyncPageFetcher<GetInventorySchemaResponse> {
        private GetInventorySchemaResponseFetcher() {
        }

        public boolean hasNextPage(GetInventorySchemaResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetInventorySchemaResponse> nextPage(GetInventorySchemaResponse previousPage) {
            if (previousPage == null) {
                return GetInventorySchemaPublisher.this.client.getInventorySchema(GetInventorySchemaPublisher.this.firstRequest);
            }
            return GetInventorySchemaPublisher.this.client.getInventorySchema((GetInventorySchemaRequest)((Object)GetInventorySchemaPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

