/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentityForTarget;

public class DescribeMaintenanceWindowsForTargetPublisher
implements SdkPublisher<DescribeMaintenanceWindowsForTargetResponse> {
    private final SsmAsyncClient client;
    private final DescribeMaintenanceWindowsForTargetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMaintenanceWindowsForTargetPublisher(SsmAsyncClient client, DescribeMaintenanceWindowsForTargetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMaintenanceWindowsForTargetPublisher(SsmAsyncClient client, DescribeMaintenanceWindowsForTargetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMaintenanceWindowsForTargetResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMaintenanceWindowsForTargetResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MaintenanceWindowIdentityForTarget> windowIdentities() {
        return this.flatMapIterable(response -> response.windowIdentities());
    }

    private class DescribeMaintenanceWindowsForTargetResponseFetcher
    implements AsyncPageFetcher<DescribeMaintenanceWindowsForTargetResponse> {
        private DescribeMaintenanceWindowsForTargetResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowsForTargetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMaintenanceWindowsForTargetResponse> nextPage(DescribeMaintenanceWindowsForTargetResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowsForTargetPublisher.this.client.describeMaintenanceWindowsForTarget(DescribeMaintenanceWindowsForTargetPublisher.this.firstRequest);
            }
            return DescribeMaintenanceWindowsForTargetPublisher.this.client.describeMaintenanceWindowsForTarget((DescribeMaintenanceWindowsForTargetRequest)((Object)DescribeMaintenanceWindowsForTargetPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

