/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity;
import software.amazon.awssdk.services.ssm.model.AssociationSyncCompliance;
import software.amazon.awssdk.services.ssm.model.CalendarNameOrARNListCopier;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputLocation;
import software.amazon.awssdk.services.ssm.model.ParametersCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetLocation;
import software.amazon.awssdk.services.ssm.model.TargetLocationsCopier;
import software.amazon.awssdk.services.ssm.model.TargetMapsCopier;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociationVersionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociationVersionInfo> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(AssociationVersionInfo.getter(AssociationVersionInfo::associationId)).setter(AssociationVersionInfo.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationVersion").getter(AssociationVersionInfo.getter(AssociationVersionInfo::associationVersion)).setter(AssociationVersionInfo.setter(Builder::associationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(AssociationVersionInfo.getter(AssociationVersionInfo::createdDate)).setter(AssociationVersionInfo.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AssociationVersionInfo.getter(AssociationVersionInfo::name)).setter(AssociationVersionInfo.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(AssociationVersionInfo.getter(AssociationVersionInfo::documentVersion)).setter(AssociationVersionInfo.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(AssociationVersionInfo.getter(AssociationVersionInfo::parameters)).setter(AssociationVersionInfo.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(AssociationVersionInfo.getter(AssociationVersionInfo::targets)).setter(AssociationVersionInfo.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleExpression").getter(AssociationVersionInfo.getter(AssociationVersionInfo::scheduleExpression)).setter(AssociationVersionInfo.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build()}).build();
    private static final SdkField<InstanceAssociationOutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputLocation").getter(AssociationVersionInfo.getter(AssociationVersionInfo::outputLocation)).setter(AssociationVersionInfo.setter(Builder::outputLocation)).constructor(InstanceAssociationOutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()}).build();
    private static final SdkField<String> ASSOCIATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationName").getter(AssociationVersionInfo.getter(AssociationVersionInfo::associationName)).setter(AssociationVersionInfo.setter(Builder::associationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationName").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxErrors").getter(AssociationVersionInfo.getter(AssociationVersionInfo::maxErrors)).setter(AssociationVersionInfo.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxConcurrency").getter(AssociationVersionInfo.getter(AssociationVersionInfo::maxConcurrency)).setter(AssociationVersionInfo.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> COMPLIANCE_SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceSeverity").getter(AssociationVersionInfo.getter(AssociationVersionInfo::complianceSeverityAsString)).setter(AssociationVersionInfo.setter(Builder::complianceSeverity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSeverity").build()}).build();
    private static final SdkField<String> SYNC_COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncCompliance").getter(AssociationVersionInfo.getter(AssociationVersionInfo::syncComplianceAsString)).setter(AssociationVersionInfo.setter(Builder::syncCompliance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncCompliance").build()}).build();
    private static final SdkField<Boolean> APPLY_ONLY_AT_CRON_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApplyOnlyAtCronInterval").getter(AssociationVersionInfo.getter(AssociationVersionInfo::applyOnlyAtCronInterval)).setter(AssociationVersionInfo.setter(Builder::applyOnlyAtCronInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyOnlyAtCronInterval").build()}).build();
    private static final SdkField<List<String>> CALENDAR_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CalendarNames").getter(AssociationVersionInfo.getter(AssociationVersionInfo::calendarNames)).setter(AssociationVersionInfo.setter(Builder::calendarNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalendarNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetLocations").getter(AssociationVersionInfo.getter(AssociationVersionInfo::targetLocations)).setter(AssociationVersionInfo.setter(Builder::targetLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SCHEDULE_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScheduleOffset").getter(AssociationVersionInfo.getter(AssociationVersionInfo::scheduleOffset)).setter(AssociationVersionInfo.setter(Builder::scheduleOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleOffset").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(AssociationVersionInfo.getter(AssociationVersionInfo::duration)).setter(AssociationVersionInfo.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetMaps").getter(AssociationVersionInfo.getter(AssociationVersionInfo::targetMaps)).setter(AssociationVersionInfo.setter(Builder::targetMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> ASSOCIATION_DISPATCH_ASSUME_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationDispatchAssumeRole").getter(AssociationVersionInfo.getter(AssociationVersionInfo::associationDispatchAssumeRole)).setter(AssociationVersionInfo.setter(Builder::associationDispatchAssumeRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationDispatchAssumeRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, ASSOCIATION_VERSION_FIELD, CREATED_DATE_FIELD, NAME_FIELD, DOCUMENT_VERSION_FIELD, PARAMETERS_FIELD, TARGETS_FIELD, SCHEDULE_EXPRESSION_FIELD, OUTPUT_LOCATION_FIELD, ASSOCIATION_NAME_FIELD, MAX_ERRORS_FIELD, MAX_CONCURRENCY_FIELD, COMPLIANCE_SEVERITY_FIELD, SYNC_COMPLIANCE_FIELD, APPLY_ONLY_AT_CRON_INTERVAL_FIELD, CALENDAR_NAMES_FIELD, TARGET_LOCATIONS_FIELD, SCHEDULE_OFFSET_FIELD, DURATION_FIELD, TARGET_MAPS_FIELD, ASSOCIATION_DISPATCH_ASSUME_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociationVersionInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String associationVersion;
    private final Instant createdDate;
    private final String name;
    private final String documentVersion;
    private final Map<String, List<String>> parameters;
    private final List<Target> targets;
    private final String scheduleExpression;
    private final InstanceAssociationOutputLocation outputLocation;
    private final String associationName;
    private final String maxErrors;
    private final String maxConcurrency;
    private final String complianceSeverity;
    private final String syncCompliance;
    private final Boolean applyOnlyAtCronInterval;
    private final List<String> calendarNames;
    private final List<TargetLocation> targetLocations;
    private final Integer scheduleOffset;
    private final Integer duration;
    private final List<Map<String, List<String>>> targetMaps;
    private final String associationDispatchAssumeRole;

    private AssociationVersionInfo(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.associationVersion = builder.associationVersion;
        this.createdDate = builder.createdDate;
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
        this.targets = builder.targets;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.associationName = builder.associationName;
        this.maxErrors = builder.maxErrors;
        this.maxConcurrency = builder.maxConcurrency;
        this.complianceSeverity = builder.complianceSeverity;
        this.syncCompliance = builder.syncCompliance;
        this.applyOnlyAtCronInterval = builder.applyOnlyAtCronInterval;
        this.calendarNames = builder.calendarNames;
        this.targetLocations = builder.targetLocations;
        this.scheduleOffset = builder.scheduleOffset;
        this.duration = builder.duration;
        this.targetMaps = builder.targetMaps;
        this.associationDispatchAssumeRole = builder.associationDispatchAssumeRole;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String associationVersion() {
        return this.associationVersion;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final String name() {
        return this.name;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final String scheduleExpression() {
        return this.scheduleExpression;
    }

    public final InstanceAssociationOutputLocation outputLocation() {
        return this.outputLocation;
    }

    public final String associationName() {
        return this.associationName;
    }

    public final String maxErrors() {
        return this.maxErrors;
    }

    public final String maxConcurrency() {
        return this.maxConcurrency;
    }

    public final AssociationComplianceSeverity complianceSeverity() {
        return AssociationComplianceSeverity.fromValue(this.complianceSeverity);
    }

    public final String complianceSeverityAsString() {
        return this.complianceSeverity;
    }

    public final AssociationSyncCompliance syncCompliance() {
        return AssociationSyncCompliance.fromValue(this.syncCompliance);
    }

    public final String syncComplianceAsString() {
        return this.syncCompliance;
    }

    public final Boolean applyOnlyAtCronInterval() {
        return this.applyOnlyAtCronInterval;
    }

    public final boolean hasCalendarNames() {
        return this.calendarNames != null && !(this.calendarNames instanceof SdkAutoConstructList);
    }

    public final List<String> calendarNames() {
        return this.calendarNames;
    }

    public final boolean hasTargetLocations() {
        return this.targetLocations != null && !(this.targetLocations instanceof SdkAutoConstructList);
    }

    public final List<TargetLocation> targetLocations() {
        return this.targetLocations;
    }

    public final Integer scheduleOffset() {
        return this.scheduleOffset;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final boolean hasTargetMaps() {
        return this.targetMaps != null && !(this.targetMaps instanceof SdkAutoConstructList);
    }

    public final List<Map<String, List<String>>> targetMaps() {
        return this.targetMaps;
    }

    public final String associationDispatchAssumeRole() {
        return this.associationDispatchAssumeRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncComplianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyOnlyAtCronInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCalendarNames() ? this.calendarNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetLocations() ? this.targetLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetMaps() ? this.targetMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.associationDispatchAssumeRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationVersionInfo)) {
            return false;
        }
        AssociationVersionInfo other = (AssociationVersionInfo)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.associationVersion(), other.associationVersion()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.documentVersion(), other.documentVersion()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.associationName(), other.associationName()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.complianceSeverityAsString(), other.complianceSeverityAsString()) && Objects.equals(this.syncComplianceAsString(), other.syncComplianceAsString()) && Objects.equals(this.applyOnlyAtCronInterval(), other.applyOnlyAtCronInterval()) && this.hasCalendarNames() == other.hasCalendarNames() && Objects.equals(this.calendarNames(), other.calendarNames()) && this.hasTargetLocations() == other.hasTargetLocations() && Objects.equals(this.targetLocations(), other.targetLocations()) && Objects.equals(this.scheduleOffset(), other.scheduleOffset()) && Objects.equals(this.duration(), other.duration()) && this.hasTargetMaps() == other.hasTargetMaps() && Objects.equals(this.targetMaps(), other.targetMaps()) && Objects.equals(this.associationDispatchAssumeRole(), other.associationDispatchAssumeRole());
    }

    public final String toString() {
        return ToString.builder((String)"AssociationVersionInfo").add("AssociationId", (Object)this.associationId()).add("AssociationVersion", (Object)this.associationVersion()).add("CreatedDate", (Object)this.createdDate()).add("Name", (Object)this.name()).add("DocumentVersion", (Object)this.documentVersion()).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).add("Targets", this.hasTargets() ? this.targets() : null).add("ScheduleExpression", (Object)this.scheduleExpression()).add("OutputLocation", (Object)this.outputLocation()).add("AssociationName", (Object)this.associationName()).add("MaxErrors", (Object)this.maxErrors()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("ComplianceSeverity", (Object)this.complianceSeverityAsString()).add("SyncCompliance", (Object)this.syncComplianceAsString()).add("ApplyOnlyAtCronInterval", (Object)this.applyOnlyAtCronInterval()).add("CalendarNames", this.hasCalendarNames() ? this.calendarNames() : null).add("TargetLocations", this.hasTargetLocations() ? this.targetLocations() : null).add("ScheduleOffset", (Object)this.scheduleOffset()).add("Duration", (Object)this.duration()).add("TargetMaps", this.hasTargetMaps() ? this.targetMaps() : null).add("AssociationDispatchAssumeRole", (Object)this.associationDispatchAssumeRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "AssociationVersion": {
                return Optional.ofNullable(clazz.cast(this.associationVersion()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "AssociationName": {
                return Optional.ofNullable(clazz.cast(this.associationName()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "ComplianceSeverity": {
                return Optional.ofNullable(clazz.cast(this.complianceSeverityAsString()));
            }
            case "SyncCompliance": {
                return Optional.ofNullable(clazz.cast(this.syncComplianceAsString()));
            }
            case "ApplyOnlyAtCronInterval": {
                return Optional.ofNullable(clazz.cast(this.applyOnlyAtCronInterval()));
            }
            case "CalendarNames": {
                return Optional.ofNullable(clazz.cast(this.calendarNames()));
            }
            case "TargetLocations": {
                return Optional.ofNullable(clazz.cast(this.targetLocations()));
            }
            case "ScheduleOffset": {
                return Optional.ofNullable(clazz.cast(this.scheduleOffset()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "TargetMaps": {
                return Optional.ofNullable(clazz.cast(this.targetMaps()));
            }
            case "AssociationDispatchAssumeRole": {
                return Optional.ofNullable(clazz.cast(this.associationDispatchAssumeRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("AssociationVersion", ASSOCIATION_VERSION_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DocumentVersion", DOCUMENT_VERSION_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Targets", TARGETS_FIELD);
        map.put("ScheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("OutputLocation", OUTPUT_LOCATION_FIELD);
        map.put("AssociationName", ASSOCIATION_NAME_FIELD);
        map.put("MaxErrors", MAX_ERRORS_FIELD);
        map.put("MaxConcurrency", MAX_CONCURRENCY_FIELD);
        map.put("ComplianceSeverity", COMPLIANCE_SEVERITY_FIELD);
        map.put("SyncCompliance", SYNC_COMPLIANCE_FIELD);
        map.put("ApplyOnlyAtCronInterval", APPLY_ONLY_AT_CRON_INTERVAL_FIELD);
        map.put("CalendarNames", CALENDAR_NAMES_FIELD);
        map.put("TargetLocations", TARGET_LOCATIONS_FIELD);
        map.put("ScheduleOffset", SCHEDULE_OFFSET_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("TargetMaps", TARGET_MAPS_FIELD);
        map.put("AssociationDispatchAssumeRole", ASSOCIATION_DISPATCH_ASSUME_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociationVersionInfo, T> g) {
        return obj -> g.apply((AssociationVersionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String associationVersion;
        private Instant createdDate;
        private String name;
        private String documentVersion;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String scheduleExpression;
        private InstanceAssociationOutputLocation outputLocation;
        private String associationName;
        private String maxErrors;
        private String maxConcurrency;
        private String complianceSeverity;
        private String syncCompliance;
        private Boolean applyOnlyAtCronInterval;
        private List<String> calendarNames = DefaultSdkAutoConstructList.getInstance();
        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();
        private Integer scheduleOffset;
        private Integer duration;
        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();
        private String associationDispatchAssumeRole;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationVersionInfo model) {
            this.associationId(model.associationId);
            this.associationVersion(model.associationVersion);
            this.createdDate(model.createdDate);
            this.name(model.name);
            this.documentVersion(model.documentVersion);
            this.parameters(model.parameters);
            this.targets(model.targets);
            this.scheduleExpression(model.scheduleExpression);
            this.outputLocation(model.outputLocation);
            this.associationName(model.associationName);
            this.maxErrors(model.maxErrors);
            this.maxConcurrency(model.maxConcurrency);
            this.complianceSeverity(model.complianceSeverity);
            this.syncCompliance(model.syncCompliance);
            this.applyOnlyAtCronInterval(model.applyOnlyAtCronInterval);
            this.calendarNames(model.calendarNames);
            this.targetLocations(model.targetLocations);
            this.scheduleOffset(model.scheduleOffset);
            this.duration(model.duration);
            this.targetMaps(model.targetMaps);
            this.associationDispatchAssumeRole(model.associationDispatchAssumeRole);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getAssociationVersion() {
            return this.associationVersion;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final InstanceAssociationOutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final String getAssociationName() {
            return this.associationName;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        @Override
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getComplianceSeverity() {
            return this.complianceSeverity;
        }

        public final void setComplianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
        }

        @Override
        public final Builder complianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
            return this;
        }

        @Override
        public final Builder complianceSeverity(AssociationComplianceSeverity complianceSeverity) {
            this.complianceSeverity(complianceSeverity == null ? null : complianceSeverity.toString());
            return this;
        }

        public final String getSyncCompliance() {
            return this.syncCompliance;
        }

        public final void setSyncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
        }

        @Override
        public final Builder syncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
            return this;
        }

        @Override
        public final Builder syncCompliance(AssociationSyncCompliance syncCompliance) {
            this.syncCompliance(syncCompliance == null ? null : syncCompliance.toString());
            return this;
        }

        public final Boolean getApplyOnlyAtCronInterval() {
            return this.applyOnlyAtCronInterval;
        }

        public final void setApplyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
        }

        @Override
        public final Builder applyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
            return this;
        }

        public final Collection<String> getCalendarNames() {
            if (this.calendarNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.calendarNames;
        }

        public final void setCalendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
        }

        @Override
        public final Builder calendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calendarNames(String ... calendarNames) {
            this.calendarNames(Arrays.asList(calendarNames));
            return this;
        }

        public final List<TargetLocation.Builder> getTargetLocations() {
            List<TargetLocation.Builder> result = TargetLocationsCopier.copyToBuilder(this.targetLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation ... targetLocations) {
            this.targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder> ... targetLocations) {
            this.targetLocations(Stream.of(targetLocations).map(c -> (TargetLocation)((TargetLocation.Builder)TargetLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getScheduleOffset() {
            return this.scheduleOffset;
        }

        public final void setScheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            if (this.targetMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetMaps;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>> ... targetMaps) {
            this.targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final String getAssociationDispatchAssumeRole() {
            return this.associationDispatchAssumeRole;
        }

        public final void setAssociationDispatchAssumeRole(String associationDispatchAssumeRole) {
            this.associationDispatchAssumeRole = associationDispatchAssumeRole;
        }

        @Override
        public final Builder associationDispatchAssumeRole(String associationDispatchAssumeRole) {
            this.associationDispatchAssumeRole = associationDispatchAssumeRole;
            return this;
        }

        public AssociationVersionInfo build() {
            return new AssociationVersionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociationVersionInfo> {
        public Builder associationId(String var1);

        public Builder associationVersion(String var1);

        public Builder createdDate(Instant var1);

        public Builder name(String var1);

        public Builder documentVersion(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder scheduleExpression(String var1);

        public Builder outputLocation(InstanceAssociationOutputLocation var1);

        default public Builder outputLocation(Consumer<InstanceAssociationOutputLocation.Builder> outputLocation) {
            return this.outputLocation((InstanceAssociationOutputLocation)((InstanceAssociationOutputLocation.Builder)InstanceAssociationOutputLocation.builder().applyMutation(outputLocation)).build());
        }

        public Builder associationName(String var1);

        public Builder maxErrors(String var1);

        public Builder maxConcurrency(String var1);

        public Builder complianceSeverity(String var1);

        public Builder complianceSeverity(AssociationComplianceSeverity var1);

        public Builder syncCompliance(String var1);

        public Builder syncCompliance(AssociationSyncCompliance var1);

        public Builder applyOnlyAtCronInterval(Boolean var1);

        public Builder calendarNames(Collection<String> var1);

        public Builder calendarNames(String ... var1);

        public Builder targetLocations(Collection<TargetLocation> var1);

        public Builder targetLocations(TargetLocation ... var1);

        public Builder targetLocations(Consumer<TargetLocation.Builder> ... var1);

        public Builder scheduleOffset(Integer var1);

        public Builder duration(Integer var1);

        public Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> var1);

        public Builder targetMaps(Map<String, ? extends Collection<String>> ... var1);

        public Builder associationDispatchAssumeRole(String var1);
    }
}

