/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.Activation;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;

public class DescribeActivationsPublisher
implements SdkPublisher<DescribeActivationsResponse> {
    private final SsmAsyncClient client;
    private final DescribeActivationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeActivationsPublisher(SsmAsyncClient client, DescribeActivationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeActivationsPublisher(SsmAsyncClient client, DescribeActivationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeActivationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeActivationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Activation> activationList() {
        return this.flatMapIterable(response -> response.activationList());
    }

    private class DescribeActivationsResponseFetcher
    implements AsyncPageFetcher<DescribeActivationsResponse> {
        private DescribeActivationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeActivationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeActivationsResponse> nextPage(DescribeActivationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeActivationsPublisher.this.client.describeActivations(DescribeActivationsPublisher.this.firstRequest);
            }
            return DescribeActivationsPublisher.this.client.describeActivations((DescribeActivationsRequest)((Object)DescribeActivationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

