/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SeveritySummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompliantSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompliantSummary> {
    private static final SdkField<Integer> COMPLIANT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CompliantCount").getter(CompliantSummary.getter(CompliantSummary::compliantCount)).setter(CompliantSummary.setter(Builder::compliantCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompliantCount").build()}).build();
    private static final SdkField<SeveritySummary> SEVERITY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SeveritySummary").getter(CompliantSummary.getter(CompliantSummary::severitySummary)).setter(CompliantSummary.setter(Builder::severitySummary)).constructor(SeveritySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeveritySummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANT_COUNT_FIELD, SEVERITY_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompliantSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer compliantCount;
    private final SeveritySummary severitySummary;

    private CompliantSummary(BuilderImpl builder) {
        this.compliantCount = builder.compliantCount;
        this.severitySummary = builder.severitySummary;
    }

    public final Integer compliantCount() {
        return this.compliantCount;
    }

    public final SeveritySummary severitySummary() {
        return this.severitySummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.severitySummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompliantSummary)) {
            return false;
        }
        CompliantSummary other = (CompliantSummary)obj;
        return Objects.equals(this.compliantCount(), other.compliantCount()) && Objects.equals(this.severitySummary(), other.severitySummary());
    }

    public final String toString() {
        return ToString.builder((String)"CompliantSummary").add("CompliantCount", (Object)this.compliantCount()).add("SeveritySummary", (Object)this.severitySummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompliantCount": {
                return Optional.ofNullable(clazz.cast(this.compliantCount()));
            }
            case "SeveritySummary": {
                return Optional.ofNullable(clazz.cast(this.severitySummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CompliantCount", COMPLIANT_COUNT_FIELD);
        map.put("SeveritySummary", SEVERITY_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompliantSummary, T> g) {
        return obj -> g.apply((CompliantSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer compliantCount;
        private SeveritySummary severitySummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CompliantSummary model) {
            this.compliantCount(model.compliantCount);
            this.severitySummary(model.severitySummary);
        }

        public final Integer getCompliantCount() {
            return this.compliantCount;
        }

        public final void setCompliantCount(Integer compliantCount) {
            this.compliantCount = compliantCount;
        }

        @Override
        public final Builder compliantCount(Integer compliantCount) {
            this.compliantCount = compliantCount;
            return this;
        }

        public final SeveritySummary.Builder getSeveritySummary() {
            return this.severitySummary != null ? this.severitySummary.toBuilder() : null;
        }

        public final void setSeveritySummary(SeveritySummary.BuilderImpl severitySummary) {
            this.severitySummary = severitySummary != null ? severitySummary.build() : null;
        }

        @Override
        public final Builder severitySummary(SeveritySummary severitySummary) {
            this.severitySummary = severitySummary;
            return this;
        }

        public CompliantSummary build() {
            return new CompliantSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompliantSummary> {
        public Builder compliantCount(Integer var1);

        public Builder severitySummary(SeveritySummary var1);

        default public Builder severitySummary(Consumer<SeveritySummary.Builder> severitySummary) {
            return this.severitySummary((SeveritySummary)((SeveritySummary.Builder)SeveritySummary.builder().applyMutation(severitySummary)).build());
        }
    }
}

