/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.InstanceAssociation;

public class DescribeEffectiveInstanceAssociationsPublisher
implements SdkPublisher<DescribeEffectiveInstanceAssociationsResponse> {
    private final SsmAsyncClient client;
    private final DescribeEffectiveInstanceAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEffectiveInstanceAssociationsPublisher(SsmAsyncClient client, DescribeEffectiveInstanceAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEffectiveInstanceAssociationsPublisher(SsmAsyncClient client, DescribeEffectiveInstanceAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEffectiveInstanceAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEffectiveInstanceAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceAssociation> associations() {
        return this.flatMapIterable(response -> response.associations());
    }

    private class DescribeEffectiveInstanceAssociationsResponseFetcher
    implements AsyncPageFetcher<DescribeEffectiveInstanceAssociationsResponse> {
        private DescribeEffectiveInstanceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEffectiveInstanceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEffectiveInstanceAssociationsResponse> nextPage(DescribeEffectiveInstanceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEffectiveInstanceAssociationsPublisher.this.client.describeEffectiveInstanceAssociations(DescribeEffectiveInstanceAssociationsPublisher.this.firstRequest);
            }
            return DescribeEffectiveInstanceAssociationsPublisher.this.client.describeEffectiveInstanceAssociations((DescribeEffectiveInstanceAssociationsRequest)((Object)DescribeEffectiveInstanceAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

